/**************************************************************************
 * ns_ncache.c
 * author: anant kumar
 * last modification: March 17, 1993
 *
 * implements negative caching
 */

#include <sys/param.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <netinet/in.h>
#include <arpa/nameser.h>
#ifndef AIX
#include <syslog.h>
#else
#include <sys/syslog.h>
#endif
#include <errno.h>
#include <stdio.h>
#include <resolv.h>
#include "../conf/portability.h"
#include "../conf/options.h"
#include "ns.h"
#include "db.h"

#ifdef NCACHE

void
cache_n_resp(msg, msglen
#ifdef VALIDATE
	     , server
#endif
	     )
	u_char *msg;
	int msglen;
#ifdef VALIDATE
	struct sockaddr_in *server;
#endif
{
	register struct databuf *dp;
	HEADER *hp;
	u_char *cp;
	char dname[MAXDNAME];
	int n;
	int type, class;
	int Vcode;
	int flags;

	hp = (HEADER *)msg;
	cp = msg+sizeof(HEADER);
  
	if ((n=dn_expand(msg, msg +msglen, cp,
			 (u_char *)dname, sizeof(dname))) < 0) {
#ifdef DEBUG
		if (debug)
			fprintf(ddt,"Query expand name failed:cache_n_resp\n");
#endif
		hp->rcode = FORMERR;
		return;
	}
	cp += n;
	GETSHORT(type, cp);
	GETSHORT(class, cp);
#ifdef DEBUG
	if (debug)
		fprintf(ddt,
			"ncache: dname %s, type %d, class %d\n",
			dname, type, class);
#endif

#ifdef VALIDATE
	Vcode = validate(dname,server,type,class,NULL);
	if (Vcode == INVALID || Vcode == VALID_NO_CACHE) {
		/*Valid_no_cache should never occur but doesn't hurt to check*/
		return;
	}
#endif
	dp = savedata(class, type, NTTL+tt.tv_sec, NULL, 0);
	dp->d_zone = DB_Z_CACHE;
#ifdef CRED
	dp->d_cred = DB_C_AUTH; /*good credibility data*/
#endif
	if(hp->rcode == NXDOMAIN) {
		dp->d_rcode = NXDOMAIN;
		flags = DB_NODATA|DB_NOTAUTH|DB_NOHINTS;
	} else {
		dp->d_rcode = NOERROR_NODATA;
		flags = DB_NOTAUTH|DB_NOHINTS;
	}

	if ((n = db_update(dname,dp,dp,flags,hashtab)) < 0) {
#ifdef DEBUG
		if (debug)
			fprintf(ddt,
			  "db_update failed return value:%d, cache_n_resp()\n",
				n);
#endif
		free((char*)dp);
		return;
	}
#ifdef DEBUG
	if (debug > 3)
		fprintf(ddt,
			"ncache succeeded: d:%s, t:%d, c:%d rcode:%d ttl:%d\n",
			dname,type,class,dp->d_rcode, dp->d_ttl-tt.tv_sec);
#endif
	return;
}

#endif /*NCACHE*/
