#ifdef __cplusplus
extern "C" {
#endif
/* @(#)unistd.h	7.1 - 87/06/16 - 00:14:25 */
/*
 * 1984 /usr/group Standard
 */

#include <sys/types.h>  /* for time_t */

/* Symbolic constants for the "access" function: */
#define R_OK 4		/* Test for "Read" Permission */
#define W_OK 2		/* Test for "Write" Permission */
#define X_OK 1		/* Test for "Execute" (Search) Permission */
#define F_OK 0		/* Test for existence of file */

/* Symbolic constants for the "lockf" function: */
#define F_ULOCK 0	/* Unlock a previously locked region */
#define F_LOCK  1	/* Lock a region for exclusive use */
#define F_TLOCK 2	/* Test and lock a region for exclusive use */
#define F_TEST  3	/* Test a region for a previous lock */

/* Symbolic constants for the "lseek" function: */
#define SEEK_SET 0	/* Set file pointer to "offset" */
#define SEEK_CUR 1	/* Set file pointer to current plus "offset" */
#define SEEK_END 2	/* Set file pointer to EOF plus "offset" */

/* Path names of the passwd file and group file: */
#define GF_PATH "/etc/group"	/* Path name of the "group" file */
#define PF_PATH "/etc/passwd"	/* Path name of the "passwd" file */
#define IN_PATH "/usr/include"	/* Path name for <...> files */

/* Structure for "utime" function: */
struct	utimbuf {
	time_t	actime; 	/* Date and time of last access */
	time_t	modtime;	/* Date and time of last modification */
};
#ifdef __cplusplus
extern void _exit (int);
extern int access (const char *, int);
extern unsigned int alarm (unsigned int);
extern int chdir (const char *);
extern int chown (const char *, unsigned short , unsigned short );
extern int close (int);
extern char * ctermid (char *);
extern char * cuserid (char *);
extern int dup (int);
extern int dup2 (int, int);
extern int execl (const char *, const char *, ...);
extern int execle (const char *, const char *, ...);
extern int execlp (const char *, const char *, ...);
extern int execv (const char *, char *const *);
extern int execve (const char *, char *const *, char *const *);
extern int execvp (const char *, char *const *);
extern int fork (void);
extern long int fpathconf (int, int);
extern char * getcwd (char *, long int );
extern unsigned short getegid (void);
extern unsigned short geteuid (void);
extern unsigned short getgid (void);
extern int getgroups (int, unsigned short *);
extern char * getlogin (void);
extern int getpgrp (void);
extern int getpid (void);
extern int getppid (void);
extern unsigned short getuid (void);
extern int isatty (int);
extern int link (const char *, const char *);
extern long lseek (int, long , int);
extern long int pathconf (const char *, int);
extern int pause (void);
extern int pipe (int *);
extern int read (int, void *, unsigned int);
extern int rmdir (const char *);
extern int setgid (unsigned short );
extern int setpgid (int , int );
extern int setsid (void);
extern int setuid (unsigned short );
extern unsigned int sleep (unsigned int);
extern long int sysconf (int);
extern int tcgetpgrp (int);
extern int tcsetpgrp (int, int );
extern char * ttyname (int);
extern int unlink (const char *);
extern int write (int, const void *, unsigned int);
#endif /* defined(__cplusplus) */
#ifdef __cplusplus
}
#endif
