/* @(#)vfs.h	7.8 88/10/24 18:02:39 */

#ifndef _h_VFS
#ifdef __cplusplus
extern "C" {
#endif
#define _h_VFS

#include <sys/types.h>
#include <sys/gfs.h>
#include <sys/vnode.h>
#include <sys/vmount.h>

/*
 * the vfs structure represents a virtual file system.
 *	One of them is created for each mounted file-system/object.
 */
struct vfs {
	struct vfs	*vfs_next;	/* vfs's are a linked list */
	struct gfs	*vfs_gfs;	/* ptr to gfs of vfs */
	struct vnode	*vfs_mntd;	/* pointer to mounted vnode, */
					/*	the root of this vfs */
	struct vnode	*vfs_mntdover;	/* pointer to mounted-over */
					/*	vnode		 */
	int		vfs_lock[2];	/* locking */
	struct vnode	*vfs_vnodes;	/* all vnodes in this vfs */
	caddr_t		vfs_data;	/* private data area pointer */
	unsigned int	vfs_number;	/* serial number to help */
					/*  distinguish between */
					/*  different mounts of the */
					/*  same object */
	int		vfs_bsize;	/* for SUN, native block size */
	short		vfs_exflags;	/* for SUN, exported fs flags */
	unsigned short	vfs_exroot;	/* for SUN, " fs uid 0 mapping */
	struct vfsstat	*vfs_stat;	/* ptr to vfs status info */
	struct vmount	*vfs_mdata;	/* record of mount arguments */
};
/* these defines are for backwards compatibility */
#define vfs_fsid	vfs_mdata->vmt_fsid 
#define vfs_date	vfs_mdata->vmt_time 
#define vfs_flag	vfs_mdata->vmt_flags
#define vfs_type	vfs_gfs->gfs_type 
#define vfs_ops		vfs_gfs->gfs_ops 

/* the defines are for the SUN style names */
#define vfs_vnodecovered vfs_mntdover
#define vfs_pdata vfs_data
/* note no define for vfs_op, use VFS_func() macros! */

/*
 * Definitions for bits in the vfs_flag
 * field of the vfs structure.
 */
#define	VFS_READONLY	0x0001		/* file system mounted rdonly	*/
#define	VFS_REMOVABLE	0x0002		/* removable (diskette) mount	*/
#define	VFS_DEVMOUNT	0x0004		/* device mount			*/
#define	VFS_REMOTE	0x0008		/* remote file system		*/
#define	VFS_DISCONNECTED	0x0010	/* disconnected/incomplete	*/
					/*	mount			*/
#define	VFS_UNMOUNTING	0x0020		/* originated by unmount()	*/
#define	VFS_SHUTDOWN	0x0040		/* forced unmount for shutdown	*/
#define VFS_VMOUNTOK	0x0080		/* dir/file mnt permission flag	*/
#define	VFS_SUSER	0x0100		/* client-side suser perm. flag */
#define VFS_INTRANSIT	0x0200		/* Mount is occuring.		*/
#define	DUMMY		0x8000		/* Dummy virtual file system	*/
/* for SUN */
#define VFS_EXPORTED	0x0200		/* file system is exported (NFS) */

/* exported vfs flags */
#define EX_RDONLY	0x01		/* exported read only */

/* 
 * Structure containing pointers to routines
 * which implement vfs operations
 */
struct vfsops {
	int (*vfs_mount)();	/* (vfsp) */
	int (*vfs_unmount)();	/* (vfsp, flag) */
	int (*vfs_root)();	/* (vfsp,vpp,flags) - get root vnode */
	int (*vfs_statfs)();	/* (vfsp,statfsp) - get fs statistics */
	int (*vfs_sync)();	/* (vfsp) */
	int (*vfs_vget)();	/* (vfsp,vpp,fidp) get vnode by file handle */
};

#define VFS_MOUNT(VFSP)		(*(VFSP)->vfs_ops->vfs_mount)(VFSP)
#define VFS_UNMOUNT(VFSP, FLG)	(*(VFSP)->vfs_ops->vfs_unmount)(VFSP, FLG)
#define VFS_ROOT(VFSP, VPP)	(*(VFSP)->vfs_ops->vfs_root)(VFSP,VPP)
#define VFS_STATFS(VFSP, SBP)	(*(VFSP)->vfs_ops->vfs_statfs)(VFSP,SBP)
#define VFS_SYNC(VFSP)		(*(VFSP)->vfs_ops->vfs_sync)(VFSP)
#define VFS_VGET(VFSP,VPP,FIDP)	(*(VFSP)->vfs_ops->vfs_vget)(VFSP,VPP,FIDP)

/* NOTE: statfs structure moved to its own include file, this is for SUN */
#include <sys/statfs.h>

#ifdef __cplusplus
}
#endif
#endif
