/* @(#)vattr.h	7.2 88/04/19 22:32:13 */
#ifndef _h_vattr
#ifdef __cplusplus
extern "C" {
#endif
#define _h_vattr

#include <sys/types.h>
#include <sys/vnode.h>
#include <sys/time.h>

/*
 * Structure describing the attributes of files across all
 * the types of file systems which are supported.  This is
 * a superset of the AIX stat structure's fields.
 */
struct vattr
{
	enum vtype	va_type;	/* vnode type			*/
	short	va_mode;		/* access mode			*/
	short	va_uid;			/* owner uid			*/
	short	va_gid;			/* owner gid			*/
	union {			/* avoid nasty short/long align problems */
		dev_t	_va_dev;	/* id of device containing file	*/
		long	_va_fsid;	/* fs id (dev for now)		*/
	} _vattr_union;
	long	va_serialno;		/* file serial (inode) number	*/
	short	va_nlink;		/* number of links		*/
	long	va_size;		/* file size in bytes		*/
	long	va_blocksize;		/* preferred blocksize for io	*/
	long	va_blocks;		/* kbytes of disk held by file	*/
/* time in vattr in now two longs, but some measure of back compatibility */
/* is maintained, the short times are "tim" vs "time" */
	struct	timeval  va_atime; 	/* time of last access */
#define va_atim va_atime.tv_sec
	struct	timeval  va_mtime;	/* time of last data modification */
#define va_mtim va_mtime.tv_sec
	struct	timeval  va_ctime;	/* time of last status change */
#define va_ctim va_ctime.tv_sec
	dev_t	va_rdev;		/* id of device			*/
	long	va_wireuid;		/* network-wide uid		*/
	long	va_wiregid;		/* network-wide gid		*/

	/* Fields added for compatability with the fullstat structure */
	long	va_nid;			/* node id			*/
	ushort	va_uid_raw;
	ushort	va_gid_raw;
	tagtype	va_uid_rev_tag;
	tagtype	va_gid_rev_tag;

	long	va_mapflag; 		/* Records whatever uid/gid	*/
					/*   mapping took place during	*/
					/*   getattr.			*/
};
#define	va_dev	_vattr_union._va_dev
#define	va_fsid	_vattr_union._va_fsid
#define	va_nodeid	va_serialno

/*
 * Defines for getattr flag argument
 */
#define	PARTIAL_STAT	0x00	/* Don't get any disk inode attributes*/
#define	FULL_STAT	0x01	/* Collect complete vattr data	*/

/*
 * Defines for getattr cmd argument
 */
#define	REVMAP_STAT	0x02	/* Do reverse id mapping, biased toward 
				 * user's uid and gid */
#define	OTHER_STAT	0x04	/* Do reverse id mapping with, bias toward 
				 * another uid/gid */
#define	SURR_STAT	0x08	/* Getting attributes of a surrogate */

/*
 * Values known to the vn_setattr
 * Must be mutually exclusive
 */
#define	V_MODE	0x1
#define	V_OWN	0x2
#define	V_UTIME	0x4

/* 
 * The following are flags for use in the timeflg (arg1) field of
 * VNOP_SETATTR call. (comment them well, this is the only place
 * they are documented.
 */

	/* 
	 * NOTE:
	 * Only flags in the range of 00100-04000 may be used,
	 * those lower than this are used in chownx.h.
	 */
#define	T_SYNC_FLAG	0100 	/* For use with the V_UTIME request,
				 * this is a DS only flag. */
#define T_SETTIME	0200	/* Used in V_UTIME to tell the vnode
				 * op that the user requested the
				 * times be set to system time.
				 */
#define T_REL5A		0400	/* Used in DS to indicate that this
				 * is a 5A V_UTIME request, this is
				 * needed because lower level clients
				 * will need a special KLUDGE to work
				 * correctly.
				 */


#ifdef __cplusplus
}
#endif
#endif
