/* @(#)user.h	7.11 8/26/88 12:54:23 */
/* @(#)user.h	7.3 87/10/26 07:44:17 */

#ifndef _h_USER
#ifdef __cplusplus
extern "C" {
#endif
#define _h_USER

#include <sys/types.h>
#include <sys/param.h>
#include <sys/dir.h>
#include <uinfo.h>
#include <sys/seg.h>
#include <sys/signal.h>
#include <a.out.h>

struct ucred {
	int	cr_ref;			/* reference count */
	uid_t   cr_uid;			/* effective user id */
	gid_t   cr_gid;			/* effective group id */
	uid_t   cr_ruid;		/* real user id */
	gid_t   cr_rgid;		/* real group id */
	uid_t   cr_luid;		/* login user id */
	short	cr_ngrps;		/* how many groups in list */
	short	cr_grpssize;		/* how big list is, units of gid_t */
	gid_t	*cr_grplst;		/* ptr to concurrent group list */
#define SHORT_NGROUPS 16		/* 16 is max DS concurrent groups */
	/* if longer than SHORT_NGROUPS, list mallocd and ALL groups go there */
	gid_t   cr_groups[SHORT_NGROUPS];	/* short list of groups */
};

#ifdef KERNEL
#define	crhold(cr)	(cr)->cr_ref++
struct ucred *crget();
struct ucred *crcopy();
struct ucred *crdup();
#endif

/*
 * The user structure.
 * One allocated per process.
 * Contains all per process data that doesn't need to be referenced
 * while the process is not running.
 * The user block is USIZE clicks long; starts at virtual kernel
 * address 3fff f000 (2 pages below top of stack segment), except for
 * kernel processes, whose u blocks live in the kernel segment;
 * contains the system stack per user; is cross referenced
 * with the proc structure for the same process.
 */
 
#define SHSIZE  32              /* size of short form exec on 32-bit host */
/* defines for u.u_compatibility bit mask */
#define PROC_RAWDIR	1	/* read directories in underlying format */
				/* system V directory by default on AIX2.2.* */
#define UCOMPAT_TRUNCATES 2	/* this process truncates file names, */
				/* and that could be dangerous, so if */
				/* lookup sees a 14 byte name, return ENOENT */

struct	user
{
	int     u_svcsav[16];           /* save all regs during svc calls */
	struct  lps u_lps;              /* per-user info from svc psb.    */
	int	u_splsav;		/* save interrupt levels per process */
	int	u_compatibility;   	/* compatibility/user mode bit masks */
	int	u_auditstatus;		/* auditing RESUME or SUSPEND */ 
	struct segbound u_sbounds[16];  /* valid addrs. in each segment   */
	label_t	u_rsav;			/* save info when exchanging stacks */
	label_t u_qsav; 		/* label var for quits and interrupts */
	label_t u_ssav; 		/* label var for forking */
	int	*u_ar0;			/* address of users saved R0 */
	int	u_arg[10];		/* arguments to current system call */
	int	*u_ap;			/* pointer to arglist */
	char	u_segflg;		/* for IO: 0=user-D 1=system 2=user-I */
	char	u_error;		/* return error code */
	ushort	u_olduid;		/* old effective user id */
	ushort	u_oldgid;		/* old effective group id */
	ushort	u_sgid;			/* saved (effective) gid from exec().
					   Should really be in proc.h with
					   p_suid, but no spares left in proc.*/
	struct ucred *u_cred;		/* user credentials (uid, gid, etc) */
#define	u_uid	u_cred->cr_uid
#define	u_gid	u_cred->cr_gid
#define	u_groups u_cred->cr_grplst
#define	u_ruid	u_cred->cr_ruid
#define	u_rgid	u_cred->cr_rgid
#define	u_luid	u_cred->cr_luid
	struct proc *u_procp;		/* pointer to proc structure */
	union {				/* syscall return values */
		struct	{
			int	r_val1;
			int	r_val2;
		} r_reg;
		off_t	r_off;
		time_t	r_time;
	} u_r;
	caddr_t	u_base;			/* base address for IO */
	unsigned u_count;		/* bytes remaining for IO */
	off_t	u_offset;		/* offset in file for IO */
	short	u_fmode;		/* file mode for IO */
	ushort	u_pbsize;		/* bytes in block for IO */
	ushort	u_pboff;		/* offset in block for IO */
	ushort	u_vfs;			/*  currently unused space */
	dev_t	u_pbdev;		/* real device for IO */
	daddr_t	u_rablock;		/* read ahead block addr */
	int     u_fsfree;               /* free blocks in current filsys */
	struct vnode *u_cdir;		/* current directory of process */
	struct vnode *u_rdir;		/* root directory of process */
	caddr_t	u_dirp;			/* pathname pointer */
	char * u_lastname;		/* lastname component	*/
	char reschars[12];		/* pad out direct replacement */
	struct vnode *u_pdir;		/* vnode of parent directory of dirp */
	struct segstate u_segst[NSEGS]; /* info on use of each segment */
	struct file *u_ofile[NOFILE];	/* pointers to file structures of open files */
	char	u_pofile[NOFILE];	/* per-process flags of open files */
	uinfo_t u_uinfo;                /* usrinfo() buffer   */
	unsigned u_tsize;		/* text size (clicks) */
	unsigned u_dsize;		/* data size (clicks) */
	unsigned u_ssize;		/* stack size (clicks) */
/* signal management */
	int	(*u_signal[NSIG])();	/* disposition of signals */
	int	u_sigmask[NSIG];	/* signals to be blocked */
	int	u_sigonstack;		/* signals to take on sigstack */
	int	u_oldmask;		/* saved mask from before sigpause */
	int	u_code;			/* ``code'' to trap */
	struct	sigstack u_sigstack;	/* sp & on stack state variable */
#define	u_onstack	u_sigstack.ss_onstack
#define	u_sigsp		u_sigstack.ss_sp

	time_t	u_utime;		/* this process user time */
	time_t	u_stime;		/* this process system time */
	time_t	u_cutime;		/* sum of childs' utimes */
	time_t	u_cstime;		/* sum of childs' stimes */
	struct profdata {		/* profile arguments */
		short	*pr_base;	/* buffer base */
		unsigned pr_size;	/* buffer size */
		unsigned pr_off;	/* pc offset */
		unsigned pr_scale;	/* pc scaling */
	} u_prof;
	unsigned   *u_ttys;             /* pointer to t_state in "tty" struct */
	dev_t   *u_ttyp;                /* pointer to pgrp in "tty" struct */
	dev_t	u_ttyd;			/* controlling tty dev */

	union execunion {
		struct exec u_exbhdr;   /* header of executable file */
		char u_exshell[SHSIZE]; /* #! + name of interpreter */
	} u_exh;
#define u_exdata    u_exh.u_exbhdr
#define u_extsiz    u_exdata.a_text
#define u_exdsiz    u_exdata.a_data
#define u_exbsiz    u_exdata.a_bss
#define u_exentloc  u_exdata.a_entry
#define u_exdbase   u_exdata.a_dbase
#define u_exflg     u_exdata.a_flags
#define u_hdrsiz    u_exdata.a_drsize
#define u_extoffs   u_exdata.a_toffs
#define u_excpu     u_exdata.a_cpu
#define u_exhlen    u_exdata.a_hdrlen
#define u_exvers    u_exdata.a_version
#define u_exmisc    u_exdata.a_misc
#define u_exsyms    u_exdata.a_syms
#define u_extrsize  u_exdata.a_trsize
#define u_extbase   u_exdata.a_tbase
#define u_exlnums   u_exdata.a_lnums

	char	u_comm[14];		/* magic number from old DIRSIZ */
	time_t	u_start;
	time_t	u_ticks;
	long	u_mem;
	long	u_ior;
	long	u_iow;
	long	u_iosw;
	long	u_ioch;
	char	u_acflag;
	char    u_onice;                /* pre monitor mode nice value */
	short	u_cmask;		/* mask for file creation */
	daddr_t	u_limit;		/* maximum write address */
	short	u_lock;			/* process/text locking flags */
	char	u_spare6;		/* currently unused space */
	char	u_mciflg;		/* _u mci stack in use */
	char	u_ncsflg;		/* new call seq. flag */
	char	spare7[3];		/* currently unused space */
	int     u_mcsav[16];            /* save all regs during mc intr */
	struct  lps u_mclps;            /* mc intr lps save area */
/* auditing stuff */
	ushort	u_svcnum;		/* this svc number */
	ushort	u_svcnarg;		/* num of args to this system call */
	char	*u_prependbuf;		/* pointer to prepend audit record */
	int	u_prependlen;		/* length of this prepend record */
	int	u_prependmask;		/* bitmask of prepend event */
	char	*u_pathbuf;		/* pathname buffer */
	int	u_pathsiz;		/* allocated size of pathname buffer */
	int	u_pathlen;		/* actual length of pathname(s) */
	ushort	u_pathcnt;		/* number of pathnames stored */
/* end of auditing stuff */
	ushort	spare8;			/* currently unused space */
	off_t	u_ttympx;		/* tty mpx value for controlling tty */
	int     u_urestart[9];          /* Task restart count and data */
	int     u_krestart[9];          /* Task restart count and data */
	char 	*u_endpath;		/* The tail end of the last path */
	int	spare9[3];		/* currently unused space */
	int     u_smax;                 /* max stack seg size (clicks) */
	int     u_dmax;                 /* max data seg size (clicks) */
	int	spare10[1];		/* actually unused space  ( P31778 )*/
					/* Save area for float pt data */
					/* for the MC68881             */
	unsigned long    u_fpptr;       /* ptr to float. pt. buffers   */
	struct {unsigned long dfracth,dfractl;} u_fpbuff1;
	struct {unsigned long dfracth,dfractl;} u_fpbuff2;
	int	u_stack[1];		/* actually unused space; Any member
					 * that needs to be added to this 
					 * structure should be added immediately
					 * above this declaration.  It shouldn't
					 * be added after this member or between
					 * any of the above members.	
				         */
					/* kernel stack per user
					 * extends from 0x3ffffffc
					 * backward not to reach here
					 */
};
#ifdef KPROCS
#define u (*(*(struct user **)0x7FC))
#else
extern struct user u;
#endif

#define	u_rval1	u_r.r_reg.r_val1
#define	u_rval2	u_r.r_reg.r_val2
#define	u_roff	u_r.r_off
#define	u_rtime	u_r.r_time

/* ioflag values: Read/Write, User/Kernel, Ins/Data */
#define	U_WUD	0
#define	U_RUD	1
#define	U_WKD	2
#define	U_RKD	3
#define	U_WUI	4
#define	U_RUI	5

#define	EXCLOSE	01

#define UF_EXCLOSE 0x1
#define UF_MAPPED  0x2
#define UF_FDLOCK  0x4
#ifdef __cplusplus
}
#endif
#endif
