/* @(#)trace.h	7.2 88/08/17 15:43:13 */

#ifndef _h_trace
#ifdef __cplusplus
extern "C" {
#endif
#define _h_trace

#include "sys/types.h"
#include "sys/param.h"


/*****************************************************************************
*                                                                            *
* Communication areas for trace driver                                       *
*
* Changes:      3/86 (vrb) rearrange fields in tr_struct; add t_struct
*****************************************************************************/

/* ioctl functions */
#define TRIOC   ('Z'<<8)
#define TRCSETC (TRIOC|0)
#define TRCGETC (TRIOC|1)
#define TRCSET  0
#define TRCRSET 1

/* argument to ioctls */
struct tr_struct {
	unsigned operation;     /* TRCSET or TRCRSET for TRCSETC calls */
	unsigned channels;      /* enabled channels */
	ushort entsize;         /* length of trace entry */
	struct trace_event * bufaddr;   /* address of the buffer to use */
	ulong bufsize;          /* buffer size to use */
	union                   /* vrm operational flags */
	  {     ushort vm_quit;
		struct
		  {     char vmid;      /* 0 = current VM */
			unsigned intr_on_quit : 1;
			unsigned mpx_no : 7;
		  } xvf;
	  } vf;
};

/* define the interrupt flag for easy loading */
#define INTR_ON_QUIT vf.xvf.intr_on_quit

/* structure of an entry returned to the user */
struct trace_event {
	time_t  stamp;          /* time stamp */
	short   timeext;        /* time stamp extension */
	short   seqno[2];       /* two 16 bit sequence number digits */
	short   hookid;         /* channel number and trace event code */
	unsigned pid;           /* process id */
	short   iodn;           /* vrm iodn or -1 */
	short   iocn;           /* vrm iocn or -1 */
	union {
		char    xcdata[20];       /* more data, depending on code */
		int     xidata[5];
	} xdata;
};

#define Cdata   xdata.xcdata
#define Idata  xdata.xidata

/* struct returned to user by trc_start() */
struct t_struct
  {     int t_PID;                      /* process ID of new trace daemon */
	struct trace_event *buff_addr;  /* addr of allocated buffer */
	int buff_len;                   /* length of buffer */
	unsigned short channel_ID;      /* mask for allocated channel */
  };

/* kernel trace function, not useful to applications */
extern tracechan;     /* channel flags */

/* macro to test for tracing, to avoid assembling complex stuff */
# define iftrace(chnum) (tracechan&(1<<(31-((chnum)>>11))))

# define trsave(chnum, len, data) \
	(iftrace(chnum)? trstore(chnum, len, data): 0)

/* Trace subchannels */
#define TR_USER		(31<<11)
#define TR_SHM		(30<<11)
#define TR_MSGQ		(29<<11)
#define TR_SEM		(28<<11)
#define TR_SIG		(27<<11)
#define TR_TIM		(26<<11)
#define TR_FS		(25<<11)
#define TR_IO		(24<<11)
#define TR_DIR		(23<<11)
#define TR_PROC		(22<<11)
#define TR_MISC		(21<<11)
#define TR_PRT          (16<<11)

/* Distributed Services subchannels */
#define TR_DS_CS        (1<<11)         /* rpc client sending           */
#define TR_DS_CR        (2<<11)         /* rpc client receiving         */
#define TR_DS_SS        (3<<11)         /* rpc server sending           */
#define TR_DS_RW        (4<<11)         /* rpc ds read/write            */
#define TR_DS_OC        (5<<11)         /* rpc ds open/close            */
#define TR_DS_LK        (6<<11)         /* rpc ds locking               */
#define TR_DS_MISC      (7<<11)         /* rpc miscellaneous            */
#define TR_DS_RIPC      (8<<11)         /* remote ipc                   */
#define TR_DS_RESERVED  (9<<11)         /* reserved                     */

/* dump a struct in hex */
#define TRCHXDMP(st,si)                                  \
{char * t_t_ptr; /* trace temp ptr */                   \
 int t_t_ctr;    /* trace temp counter */               \
 int t_t_size;   /* trace temp size */                  \
 for (t_t_size=(si),t_t_ptr=(char *)(&st);              \
      t_t_size; t_t_size--, t_t_ptr++)                  \
   printf("%x ", *t_t_ptr);                             \
   printf("\n");                                        \
}
#ifdef __cplusplus
}
#endif
#endif

