/* @(#)tape.h	7.1 87/06/15 23:39:37 */
#ifndef _h_tape
#ifdef __cplusplus
extern "C" {
#endif
#define _h_tape

#include "sys/types.h"
#include "sys/param.h"

/*
 * Structures and definitions for cartridge tape io control commands
 */

/* structure for STIOCTOP - streaming tape op command */
struct	stop	{
	short	st_op;		/* operations defined below */
	daddr_t	st_count;	/* how many of them */
};

/* operations */
#define	STRESET 5	/* Reset device. */
#define STREW	6	/* rewind */
#define STERASE 7	/* erase tape, retension, leave at load point */
#define STRETEN 8	/* erase tape, retension, leave at load point */
#define STWEOF	10	/* write an end-of-file record */
#define STFSF	11	/* forward space file */
#define STFSR	13	/* forward space record */
#define STRAS1	15	/* drive self test 1 */
#define STRAS2	16	/* drive self test 2 */
#define STRAS3	17	/* drive self test 3 */
			/* this test (3) needs a an erased, */
			/* write-protected tape. */

/* structure for STIOCGET - streaming tape get status command */

struct	stget	{
	short	st_type;	/* type of device */
/* the following structure is grossly device dependent */
/* Ok for now, we only have one device. */
	struct dsreg {
		unsigned short ds_dstat;   /* drive status */
		unsigned short ds_soft;	   /* soft error count */
		unsigned short ds_under;   /* underrun count */
		unsigned char  ds_rcom;	   /* command recieved by adapter */
		unsigned char  ds_blk;	   /* adapter block count */
		unsigned char  ds_rstat;   /* status register */
		unsigned char  ds_code;    /* adapter completion code */
		unsigned char  ds_lcom;	   /* last command given to adapter */
		unsigned char  ds_lstcom;  /* last streaming tape device */
					   /* drive command */
		unsigned char  ds_res[4];  /* reserved */
	} st_dsreg;
/* end device-dependent structure */
};

/*
 * Constants for st_type byte
 */
#define	ST_ISST		0x01

/* mag tape io control commands */
#define STIOC		('S'<<8)
#define	STIOCTOP	(STIOC|1)			/* do a mag tape op */
#define	STIOCGET	(STIOC|2)			/* get tape status */
#ifdef __cplusplus
}
#endif
#endif
