/* @(#)stat.h	7.2 88/04/19 22:32:00 */

#ifndef _h_STAT
#ifdef __cplusplus
extern "C" {
#endif
#define _h_STAT

#include <sys/types.h>

/*
 * Structure of the result of stat
 */

struct  stat
{
	dev_t   st_dev;            /* ID of device containing */
				   /* a directory entry for this file */
				   /* File serial + device uniquely */
				   /* identifies the file within the system */
	ino_t   st_ino;            /* File serial number */
	ushort  st_mode;           /* File mode; see #define's below */
	short   st_nlink;          /* Number of links */
	ushort  st_uid;            /* User ID of the file's owner */
	ushort  st_gid;            /* Group ID of the file's group */
	dev_t   st_rdev;           /* ID of device */
				   /* This entry is defined only for */
				   /* character or block special files */
	off_t   st_size;           /* File size in bytes */
	time_t  st_atime;          /* Time of last access */
	time_t  st_mtime;          /* Time of last data modification */
	time_t  st_ctime;          /* Time of last file status change */
				   /* Time measured in seconds since */
				   /* 00:00:00 GMT, Jan. 1, 1970 */
};

#define S_IFMT	0170000            /* type of file */
#define S_IFDIR	0040000            /* directory */
#define S_IFCHR	0020000            /* character special */
#define S_IFBLK	0060000            /* block special */
#define S_IFREG	0100000            /* regular */
#define S_IFIFO	0010000            /* fifo */
#define	S_IFLNK	0120000		   /* symbolic link */
#define S_ISUID  04000             /* set user id on execution */
#define S_ISGID  02000             /* set group id on execution */
#define S_ISVTX  01000             /* save text even after use */
#define S_IREAD  00400             /* read permission, owner */
#define S_IWRITE 00200             /* write permission, owner */
#define S_IEXEC  00100             /* execute/search permission, owner */

/*  /usr/group definitions  */
#define S_IRWXU  00700             /* read,write,execute permission: owner */
#define S_IRUSR  00400             /* read permission: owner */
#define S_IWUSR  00200             /* write permission: owner */
#define S_IXUSR  00100             /* execute/search permission: owner */
#define S_IRWXG  00070             /* read,write,execute permission: group */
#define S_IRGRP  00040             /* read permission: group */
#define S_IWGRP  00020             /* write permission: group */
#define S_IXGRP  00010             /* execute/search permission: group */
#define S_IRWXO  00007             /* read,write,execute permission: other */
#define S_IROTH  00004             /* read permission: other */
#define S_IWOTH  00002             /* write permission: other */
#define S_IXOTH  00001             /* execute/search permission: other */
#define S_ENFMT  S_ISGID           /* record locking enforcement flag */
#define S_IFMPX (S_IFCHR|S_ISVTX)  /* multiplex character special file */
#define S_ISFIFO(m) (((m)&(S_IFMT)) == (S_IFIFO))
#define S_ISDIR(m)  (((m)&(S_IFMT)) == (S_IFDIR))
#define S_ISCHR(m)  (((m)&(S_IFMT)) == (S_IFCHR))
#define S_ISBLK(m)  (((m)&(S_IFMT)) == (S_IFBLK))
#define S_ISREG(m)  (((m)&(S_IFMT)) == (S_IFREG))
#define S_ISMPX(m)  (((m)&(S_IFMT|S_ISVTX)) == (S_IFMPX))

#ifdef __cplusplus
extern int chmod (const char *, int );
extern int fstat (int, struct stat *);
extern int mkdir (const char *, int );
extern int mkfifo (const char *, int );
extern int stat (const char *, struct stat *);
extern int umask (int );
#endif /* defined(__cplusplus) */
#define S_ISLNK(mode) (((mode) & S_IFMT) == S_IFLNK)
#ifdef __cplusplus
}
#endif
#endif
