/* "@(#)space.h	7.7 89/08/04 16:23:17" */

#ifndef _h_SPACE
#ifdef __cplusplus
extern "C" {
#endif
#define _h_SPACE

#include <sys/tty.h>
struct	cblock	cfree[NCLIST];

#include <sys/buf.h>
struct	buf	bfreelist;	/* head of the free list of buffers */
struct	pfree	pfreelist;	/* Head of physio header pool */
struct	buf	pbuf[NPBUF];	/* Physical io header pool */
struct  buf     dfreelist;      /* head of DMA header pool */
struct  buf     dbuf[NDBUF];    /* DMA io header pool */

struct	hbuf	hbuf[NHBUF];	/* buffer hash table */

char    pinkbuf = PINKBUF; /* pin kernel buffers - boolean */

#include <sys/file.h>
struct	file	file[NFILE];	/* file table */

#include <sys/inode.h>
struct  inode    inode[NINODE];         /* inode table */

#include <sys/flock.h>
struct filock flox[NFLOCKS];		/* lock table */

#include <sys/proc.h>
struct	proc	proc[NPROC];	/* process table */

#ifdef KPROC
#include <sys/kproc.h>
struct  kuser    kp_user[NKPROC];    /* process table */
#include <sys/dskproc.h>
struct kproctl kproctl[DSNKPROC];
#include "sys/dsnode.h"
struct node	node[MAXNODE];		/* node table	*/

 
struct dsncb	dsncb[NNCB];		/* node control block */
struct dsncb	dswcb[1];		/* wildcard control block */
struct dsncb	dsocb[1];		/* outbound control block */
struct dsncb	dsipc[1];		/* ipc control block */

#ifdef OLDCRAP
struct dsncb    usertbl[5];             /* usertbl control block */
#endif
#endif

#include <sys/text.h>
struct	text text[NTEXT];	/* text table */
struct  shlib shlib[NSHLIB];    /* shared library table */

#include <sys/map.h>
struct map kmap[KMAPSIZ] = {mapdata(KMAPSIZ)};
caddr_t kspace, ksegalloc();

#include <sys/callo.h>
struct callo callout[NCALL];

#include <sys/mount.h>
struct mount mount[NMOUNT];

#include <sys/dump.h>		/*dump table */
struct segdump dmpsegs[NPROC];

#include <sys/elog.h>
#include <sys/err.h>
struct	err	err = {
	NESLOT,
};

#include <sys/sysinfo.h>
struct sysinfo sysinfo;
struct syswait syswait;
struct syserr syserr;

#include <sys/opt.h>

#include        <sys/kcfg.h>
struct bptr bptr[MAXBIOS];

#include <sys/var.h>
struct var v = {
	NBUF,
	NCALL,
	NINODE,
	(char *)(&inode[NINODE]),
	NFILE,
	(char *)(&file[NFILE]),
	NMOUNT,
	(char *)(&mount[NMOUNT]),
	NPROC,
	(char *)(&proc[1]),
	NTEXT,
	(char *)(&text[NTEXT]),
	NFLOCKS,
	(char *)(&flox[NFLOCKS]),
	NCLIST,
	NSABUF,
	MAXUP,
	SMAPSIZ,
	NHBUF,
	NHBUF-1,
	NPBUF,
	NDBUF,
	NKPROC,
	(char *)(&kp_user[NKPROC]),
 	MAXNODE,
 	(char *)(&node[MAXNODE]),
 	NNCB,
 	(char *)(&dsncb[NNCB]),
	DSNKPROC,
	NSHLIB,
	(char *)(&shlib[NSHLIB]),
	MAXBIOS,
};

#include <sys/init.h>

#ifdef	TRACE_0
#include <sys/trace.h>
struct trace trace[TRACE_0];
#endif

#ifdef	X25_0
#include <sys/x25.h>
struct x25slot x25slot[X25_0];
struct x25tab x25tab[X25_0];
struct x25timer x25timer[X25_0];
struct x25link x25link[X25LINKS];
struct x25timer *x25thead[X25LINKS];
struct x25lntimer x25lntimer[X25LINKS];
struct csibd x25bd[X25BUFS];
struct csibuf x25buf;
struct x25info x25info =
	{X25_0, X25_0, X25LINKS, X25BUFS, X25BYTES};
#endif

#ifndef MINI_UNIX
#if MESG==1
#include        <sys/ipc.h>
#include        <sys/msg.h>
struct map	msgmap[MSGMAP];
struct msqid_ds	msgque[MSGMNI];
struct msg	msgh[MSGTQL];
struct msginfo	msginfo = {
	MSGMAP,
	MSGMAX,
	MSGMNB,
	MSGMNI,
	MSGSSZ,
	MSGTQL,
	MSGSEG
};
#endif

#if SEMA==1
#	ifndef IPC_ALLOC
#       include <sys/ipc.h>
#	endif
#include        <sys/sem.h>
struct semid_ds	sema[SEMMNI];
struct sem	sem[SEMMNS];
struct map	semmap[SEMMAP];
struct	sem_undo	*sem_undo[NPROC];
#define	SEMUSZ	(sizeof(struct sem_undo)+sizeof(struct undo)*SEMUME)
int	semu[((SEMUSZ*SEMMNU)+NBPW-1)/NBPW];
union {
	short		semvals[SEMMSL];
	struct semid_ds	ds;
	struct sembuf	semops[SEMOPM];
}	semtmp;

struct	seminfo seminfo = {
	SEMMAP,
	SEMMNI,
	SEMMNS,
	SEMMNU,
	SEMMSL,
	SEMOPM,
	SEMUME,
	SEMUSZ,
	SEMVMX,
	SEMAEM
};
#endif
#endif

#if SHMEM==1
#	ifndef	IPC_ALLOC
#       include <sys/ipc.h>
#	endif
#include        <sys/shm.h>
struct shmid_ds	shmem[SHMMNI];	
struct	shminfo shminfo = {
	SHMMAX,
	SHMMIN,
	SHMMNI,
	SHMSEG,
	SHMBRK,
	SHMALL
};
#endif

#include <sys/robust.h>
int     danger = 0;
int     synchmode = 0;

#include <sys/dircache.h>	/* Directory caching */

dcbuf_t dircache[DCPOOLS * DCSPLEN];
struct subpool subpool[DCPOOLS];

int dcsplen = DCSPLEN;
int dcpools = DCPOOLS;

#include <sys/vspace.h>		/* Virtual file system structures */

#ifdef __cplusplus
}
#endif
#endif
