/* @(#)mntctl.h	7.3 89/01/25 16:06:08 */
#ifndef _h_mntctl
#ifdef __cplusplus
extern "C" {
#endif
#define _h_mntctl

#include <sys/types.h>
#include <sys/vmount.h>

/*
 * mntctl.h
 */

/* this is the list of possible mount control commands                  */
/* NO MORE!!! These two commands are no longer supported. See vmount.h  */
/*  	      for the only supported command definition -- MCTL_QUERY.  */
#define MC_MOUNTS       0       /* get mount status information         */
#define MC_UMOUNTS	1	/* force unmout of particular mount point
				 * and all mount points below it.
				 */

/* This is the structure of the mount information that is returned
   from the mntctl() system call.  An array of these structures
   immediately follows the buffer's header (of struct bheader type).
   When the mntctl() system call returns successfully, the number of
   elements in the array is contained in the buffer header field size.  */

struct  minfo
{
        unsigned long m_nid;    /* the nid of a remote mount            */
        char         *m_object; /* path of the mounted object           */
        char         *m_stub;   /* path of the mounted-over object      */            
        unsigned int m_flag;    /* flag indicating whether a vmount is
                                   read-only, removable, device, or
                                   remote                               */
        time_t       m_date;    /* date that vfs was created            */
};

/* the mntctl buffer must have this structure as its header             */
struct bheader
{
        unsigned long nid;      /* node id of machine to get mount
                                   status from                          */
        int           reserved; /* for internal use of system call      */
        unsigned int  size;     /* # of minfo structures in buffer OR
                                   required size of buffer              */
        struct minfo  m[1];     /* start of minfo descriptions          */
} ;

/* The search info struct is used internally by mntctl as a handy place
 * to stick things that we need to keep track of during the search of the
 * VFS tree.
 */
struct srch_info {		
	int	s_mcount;	/* number of mounts */
	int	s_bcount;	/* number of bytes we need to hold the object */
				/* and stub path names.			      */
	struct minfo *s_mptr;	/* pointer to the minfo structs in bheader    */
	char	*s_strptr;	/* pointer to string space in buf	      */
};

/* Flags used by the search routine */
#define	COUNT		0x01		/* Count the nodes */
#define	F_UNMOUNT	0x02		/* Force unmount all nodes */

#ifdef __cplusplus
}
#endif
#endif
