/* @(#)mapf.h	7.1 87/06/15 23:46:38 */
#ifndef _h_mapf
#ifdef __cplusplus
extern "C" {
#endif
#define _h_mapf

#include <sys/param.h>
#include <sys/seg.h>
/*
**      This is the mapnode structure.   One of these is allocated for
**      each mapped file, and a pointer to it is saved in the inode
**      structure.   It is released after the last user who has the mapped
**      file open has closed the file
*/

struct mapnode {
	short m_rwseg;          /* read/write segment id */
	short m_scwseg;         /* shared copy-on-write segment id */
	int m_rwcnt;            /* read/write count */
	int m_rocnt;            /* read/only count */
	int m_scwcnt;           /* shared copy-on-write count */
	struct segoffs *m_segoffs; /* segment offsets pointer */
};

/*
**      This is the structure passed to the VRM for the Map Page Range SVC
*/

struct mprsvc {
	short segid;            /* segment id of the mapped segment */
	char mode;              /* mode - rw, cw, wn */
	char res1;              /* reserved */
	long fpage;             /* first page in the range */
	long npage;             /* number of pages in the range */
	short iodn;             /* subject minidisk IODN */
	short nrange;           /* number of block ranges */
	struct range {
		long sblock;    /* offset of first block in the range */
		long nblock;    /* number of blocks in the range */
	} r[MRANGE];            /* number of ranges in a structure */
};

#define MBMAP(ip, off, flag) mbbmap(ip, off, flag, (struct iblock *)0)
#define FPAGE(a) (((long)(a))>>BPCSHIFT)
#define PAGEOFF(a) (((long)(a)&~BASE(0xf))>>BPCSHIFT)
#define SEGOFFSET(x) ((x)&0x0fffffff)
#define PURPGIFN	0	/* if needed */
#define PURPGFWR	1	/* forced write */
#define PURPGAFWR	2	/* async forced write (causes interrupt) */

#define KEEPFRAMES    0x80000000 /* keep frames in memory */
#define RELFRAMES       0       /* release frames in memory */

#define UNMAPSYNC       0       /* sync. operation */

#define BNDUP64K(x) (((x)+0xffff)&~(long)0xffff)
#define BNDDN64K(x) ((x)&~(long)0xffff))
#define BNDUP2K(x)  (((x)+0x7ff)&~(long)0x7ff)
#define BNDDN2K(x)  ((x)&~(long)0x7ff)

#define MAPFPPNORM PPKRWUR_   /* unprotect pages */
#define MAPFCRMODE CR_URO     /* create segment */

#ifdef __cplusplus
}
#endif
#endif
