/* @(#)iocfg.h	7.1 87/06/15 23:43:23 */
#ifndef _h_iocfg
#define _h_iocfg

/* iocfg structure for configuring kernel device drivers
*/

struct iocfgdev
{
 struct
 {
 unsigned short  gen;
 unsigned short  user;
 }flags;
 unsigned short  iodn;
 unsigned short  iocn;                  /* optional field  */
 char         dname[4];                 /* device name     */
 char            *pntr;                 /* optional pointer field for
					   binding information
					*/
 unsigned        resvd;
};

					/* generic flags - definitions  */

#define IOADD   01                      /* add operation                */
#define IODEL   02                      /* delete (stop operation)      */
#define IOCHG   04                      /* change operation             */
#define IOEXCL  08                      /* exclusive use request        */
#define IOPNTR  10                      /* pointer field defined        */


#define IOCFGSIZE sizeof(struct iocfgdev)


struct iocfg
{
 unsigned  devcount;                    /* number of devices being
					   configured
					*/

 char         iocfgdev[1];              /* repeated number of times in
					   devcount field
					*/
 };
#endif
