#ifdef __cplusplus
extern "C" {
#endif
/* @(#)gfs.h	1.2 88/04/19 18:57:53 */
/*
 * PRELIMINARY as of 12/3/87 glo
 * gfs struct defines
 *
 * COPYRIGHT 1987 IBM CORP.
 *
 */
#include <sys/types.h>

#ifndef _h_GFS
#define _h_GFS

struct gfs {
	struct vfsops	*gfs_ops;
	struct vnodeops	*gn_ops;
	int		gfs_type;	/* type of gfs (from <sys/vmount.h>) */
	char		gfs_name[16];	/* name of vfs (eg. "aix","nfs", ...)*/
	int		(*gfs_init)();	/* ( gfsp ) - if ! NULL, */
					/*   called once to init gfs */
	int		gfs_flags;	/* flags for gfs capabilities */
	caddr_t		gfs_data;	/* ptr to gfs's private config data */
};

/* defines for gfs_flags */
#define GFS_SYS5DIR	0x00000001	/* directory entries are 16 bytes */
#define GFS_REMOTE	0x00000002	/* this is a remote file system */

#endif

#ifdef __cplusplus
}
#endif
