/* @(#)getattr.h	7.4 88/04/19 22:29:54 */

#ifndef _H_GETATTR
#ifdef __cplusplus
extern "C" {
#endif
#define _H_GETATTR

#include <sys/inode.h>

struct gattr_request		/* Parameters sent to dfs_getattr() */
{
	int flag;		/* mapping + full/partial/surrogate info */
	ulong uidbias;		/* in case of OTHER biasing in uid mapping */
	ulong gidbias;		/* ditto gid mapping */
	fhandle_t fh;
};

struct gattr_response		/* Parameters received from dfs_getattr() */
{
	struct vattr v;
};

struct flush_request		/* Parameters sent to dfs_flush() */
{
	union
	{
		struct filehandle fileh;/* version with fields */
		fhandle_t fhandle;	/* opaque version */
	} freq;
};

struct flush_response		/* Parameters received from dfs_flush() */
{
	short siflag;
	long sisize;
};

/*
 * Define for passing a file's i_sflag through the
 * vattr struct to fullstat1. Temporary, for testing.
 */
#define	va_syncflag	va_other_uid

#ifdef __cplusplus
}
#endif
#endif
