/* @(#)fpfp.h	7.1 - 87/06/15 - 23:36:02 */
#ifndef _h_FPFP
#ifdef __cplusplus
extern "C" {
#endif
#define _h_FPFP


/* Floating point accelerator/emulator interface definitions */

typedef struct {
	unsigned operation:8;   /* operation being performed */
	unsigned operand1:4;    /* operand 1 */
	unsigned operand2:4;    /* operand 2 */
	unsigned rsrvd:8;       /* RESERVED */
	unsigned exception:3;   /* exception being trapped */
	unsigned io_flag:1;     /* invalid operation occurred */
	unsigned dz_flag:1;     /* divide by zero occurred */
	unsigned of_flag:1;     /* overflow occurred */
	unsigned uf_flag:1;     /* underflow occurred */
	unsigned ir_flag:1;     /* inexact occurred */
} FP_SEAR;

typedef struct {
	unsigned kill:1;	/* SIGFPE on exception */
	unsigned xcp_flag:1;    /* exception occurred */
	unsigned io_flag:1;     /* invalid operation occurred */
	unsigned io_xpt:1;      /* exception on invalid operation */
	unsigned dz_flag:1;     /* divide by zero occurred */
	unsigned dz_xpt:1;      /* exception on divide by zero */
	unsigned of_flag:1;     /* overflow occurred */
	unsigned of_xpt:1;      /* exception on overflow */
	unsigned uf_flag:1;     /* underflow occurred */
	unsigned uf_xpt:1;      /* exception on underflow */
	unsigned precision:1;   /* rounding precision */
	unsigned rsvd10:10;     /* reserved */
	unsigned cmp_rslt:2;    /* comparison result */
	unsigned rnd_mode:2;    /* rounding mode */
	unsigned ir_flag:1;     /* inexact result occurred */
	unsigned ir_xpt:1;      /* exception on inexact result */
	unsigned rsvd2:2;       /* reserved */
	unsigned mc_type:3;     /* machine communications type */
} FP_STATUS;

/* initializers for fields of FP_STATUS, as fields and as an unsigned */
/* see also libfp/xFP0.c */
#define FP_S_flds {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0};
#define FP_S_unsgd 0x00000008

typedef unsigned long FP_FLOAT;

typedef double FP_DOUBLE;

/* rounding mode values */
#define FP_NEAR 0               /* round to nearest */
#define FP_ZERO 1               /* round toward zero */
#define FP_UP   2               /* round toward +infinity */
#define FP_DOWN 3               /* round toward -infinity */

	/* return constants from comparison routines */

#define LESSTHAN        -1
#define EQUAL           0
#define GREATER         1

extern void (*_fpfpf[])();       /* emulation and/or current vector   */
extern void (*_fpfa1f[])();      /* FPA-I vector    */
extern void (*_fpfa2f[])();      /* FPA-II vector - no DMA  */
extern void (*_fpfa2fA[])();     /* FPA-II vector - with DMA  */
extern void (*_fpfa8f[])();      /* 68881 vector    */

#include <sys/fpfpi.h>

extern  FP_DOUBLE       
	ieeeatof(),	ieeeldexp(),	ieeefrexp(),	ieeemodf(),
	_FPrdd(),       _FPi2d(),       _FPcpd(),       _FPcpdi(),
	_FPf2d(),       _FPf2di(),      _FPngd(),       _FPngdi(),
	_FPabd(),       _FPabdi(),      _FPntd(),       _FPntdi(),
	_FPadd(),       _FPaddi(),      _FPsbd(),       _FPsbdi(),
	_FPmld(),       _FPmldi(),      _FPdvd(),       _FPdvdi(),
	_FPrmd(),       _FPrmdi(),      _FPsqd(),       _FPsqdi(),
	_FPcsd(),       _FPyl2x(),      _FPtan(),       _FPatan(),
	_FP2xm1(),      _FPylp1(),      _FPadd3(),      _FPsbd3(),
	_FPmld3(),      _FPdvd3(),      _FPf2d2(),      _Ebsin(),
	_Ebsini(),      _Ebcos(),       _Ebcosi(),      _Ebtan(),
	_Ebtani(),      _Ebexp(),       _Ebexpi(),      _Ebatan(),
	_Ebatani(),	_Ebacos(),	_Ebacosi(),	_Ebasin(),
	_Ebasin(),      _Eblog(),       _Eblogi(),      _Eblog10(),
	_Eblog10i(),    _Eblogb(),      _Eblogbi(),     _Ebatan2(),
	_Ebatan2i(),    _Ebscalbi(),    _Ebmodd(),      _Ebmoddi(),
	_FPlmrd(),      _FPsmrd();

extern FP_FLOAT
	_FPrdf(),       _FPi2f(),       _FPcpf(),       _FPcpfi(),
	_FPd2f(),       _FPd2fi(),      _FPngf(),       _FPngfi(),
	_FPabf(),       _FPabfi(),      _FPntf(),       _FPntfi(),
	_FPadf(),       _FPadfi(),      _FPsbf(),       _FPsbfi(),
	_FPmlf(),       _FPmlfi(),      _FPdvf(),       _FPdvfi(),
	_FPrmf(),       _FPrmfi(),      _FPsqf(),       _FPsqfi(),
	_FPcsf(),       _FPadf3(),      _FPsbf3(),      _FPmlf3(),
	_FPdvf3(),      _FPd2f2();

#ifdef __cplusplus
}
#endif
#endif


