/* @(#)fd.h	7.1 87/06/15 23:33:50 */
#ifndef _h_fd
#define _h_fd


/* floppy driver io control commands */
#define FDIOC		('F'<<8)
#define	FDIOCVER	(FDIOC|1)			/* set verify state */
#define	FDIOCSTAT	(FDIOC|2)		/* get current verify state */
#define	FDIOCFORMAT	(FDIOC|3)		            /* format track */
#define	FDIOCGINFO 	(FDIOC|4)		          /* get drive info */
#define	FDIOCSINFO 	(FDIOC|5)		          /* set drive info */
#define	FDIOCERESET	(FDIOC|6)	        /* reset drive's error flag */

#define		D_48	1			  /* 48 tpi, aka 360K drive */
#define		D_96	2		          /* 96 tpi, aka 1.2M drive */

struct fdinfo {
	short	type;				            /* D_48 or D_96 */
	short	reserved;
	int	nsects;					     /* 8, 9, or 15 */
	int	sides;			/* 0-single sided; 1 - double sided */
	int	ncyls;						/* 40 or 80 */

};

#endif
