/* @(#)err.h	7.1 87/06/15 23:39:43 */
#ifndef _h_err
#ifdef __cplusplus
extern "C" {
#endif
#define _h_err

#include "sys/map.h"
#include "sys/types.h"
#include "sys/param.h"

/*
 * structure of the err buffer area
 */
#include <sys/erec.h>
#define	NESLOT	40
#define	E_LOG	01
#define	E_SLP	02


struct err {
	int		e_nslot;		/* number of errslots */
	int		e_flag;			/* state flags */
	struct errhdr	**e_org;		/* origin of buffer pool */
	struct errhdr	**e_nxt;		/* next slot to allocate */
	struct errslot {
		int	slot[sizeof(struct errhdr)];
	} e_slot[NESLOT];			/* storage area */
	struct map	e_map[(NESLOT+3)/2];	/* free space in map */
	struct errhdr	*e_ptrs[NESLOT];	/* pointer to logged errors */
};

extern struct err err;

struct errhdr	*geteslot();
struct errhdr	*geterec();
#ifdef __cplusplus
}
#endif
#endif
