/* @(#)dynaprobe.h	7.3 88/08/29 16:28:07 */
/*----------------------------------------------------------------------------*/
/* Macros and Declarations to interface with Dynaprobe Hardware Monitor       */
/*----------------------------------------------------------------------------*/
#ifndef _h_DYNAPROBE
#define _h_DYNAPROBE

typedef struct {                /*------------------------*/
	char dynapad[0x110];    /* Move to Offset 110 HEX */
	short dyna110;          /* - 2 Bytes     at 110   */
	short dyna112;          /* - 2 Bytes     at 112   */
} dynastr;                      /*------------------------*/

typedef struct {                /*------------------------*/
	char dynapad[0x118];    /* Move to Offset 118 HEX */
	int   dyna118;          /* - 4 Bytes     at 118   */
} dynastr_type;                 /*------------------------*/

                                /*----------------------------*/
extern int dynaflag;		/* Global Dynaprobe Flag Word */
                                /*----------------------------*/


/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* Dynaprobe Macro to write to Offset 110 with "hook" and "data".             */
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
# define dynaprobe(hook,data) \
	{       register dynastr *__d_p = (dynastr*)0xf0000000; \
		if(dynaflag) {  \
			__d_p->dyna110 = (data); \
			__d_p->dyna112 = (hook<<4)|(((data)>>12)&017); \
	} }

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/* Dynaprobe Macro to write to Offset 118 with "hook", "type", and "data".    */
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
# define dynaprobe_type(hook,type,data) \
	{       register dynastr_type *__d_p_type = (dynastr_type*)0xf0000000; \
		if(dynaflag) {  \
			__d_p_type->dyna118 = (hook<<24)|(type<<16)|(data); \
	} }






#endif
