/* @(#)dstables.h	7.3 88/04/22 17:30:28 */
/*
 * dstables.h - DS specific parts of tables (see <sys/table.h>)
 */
#ifndef _h_dstables
#define _h_dstables

/*  defines for dsgetid                                              */
#define UID  0
#define GID  1
#define WILDUID  0x01
#define WILDGID  0x02
 
#ifdef NEVER /* table types are defined in <sys/table.h> */
/*  defines for control blocks                                       */
#define DSNCB   01                /*  DSNCB - Node Control Block     */
#define DSOCB   02                /*  DSOCB - Outbound Control Block */
#define DSWCB   04                /*  DSWCB - Wilcard Control Block  */
#define DSIPC   010               /*  DSIPC - IPC key table entries  */
#endif /*NEVER*/
 
struct idrow {
   long  wireid;         /* The id that arrived with the request     */
   short localid;        /* The local id qhich is the result of a    */
                         /* translate.                               */
   short pad;            /* Dummy for alignment purposes             */
};
 
struct dsxlate {
   short rlv1;           /* Reserved - must be 0                     */
   short gid;            /* The local wildcard gid for this node.    */
   short uid;            /* The local wildcard uid for this node     */
   char  flag;           /* The 0x01 bit is set if there is a        */
                         /* wildcard uid for this node.              */
                         /* The 0x02 bit is set if there is a        */
                         /* wildcard gid for this node.              */
   char  pad1;           /* Dummy for alignment purposes.            */
   unsigned short numuids; /* The number of uid translate rows.      */
   unsigned short numgids; /* The number of gid translate rows.      */
   short pad2;           /* Dummy for alignment purposes.            */
   struct idrow idrow[1]; /* The first row of translate info.        */
                         /* Rest of translates follow.               */
			 /* The dsxlate structure, the idrow
			    structure, and all the rest of the of
			    translate rows are loaded as one table
			    by loadtbl.                              */
};
 
struct dsipc {
   long   inkey;         /* input key                                */
   long   nid;           /* nid - null if for the local node         */
   long   outkey;        /* result key                               */
};
 
#endif
