/* @(#)dsstate.h	7.1 87/06/15 23:44:38 */
#ifndef _h_dsstate
#define _h_dsstate

struct ds_state {
   short i_state;               /* input state               */
   short i_kprocs;              /* input number of kprocs    */
   short r_state;               /* result state              */
   short r_kprocs;              /* result number of kprocs   */
   int   reserved[4];           /* reserved                  */
};

extern struct ds_state ds_state;
 
/*  defines for i_state                                                  */
 
#define DS_ALLOW_ALL         01    /* allow all requests                 */
#define DS_BLOCK_ALL         02    /* block all requests                 */
#define DS_ALLOW_SERV        04    /* allow all server requests          */
#define DS_BLOCK_SERV        010   /* block all server requests per mask */
#define DS_START_CLIENT_SYNC 020   /* start client sync                  */
#define DS_END_CLIENT_SYNC   040   /* end client sync                    */
#define DS_START_SERV_SYNC   0100  /* start server sync                  */
#define DS_END_SERV_SYNC     0200  /* end server sync                    */
#define DS_STARTK            0400  /* start distributed services kprocs  */
 
/*   defines for r_state                                            */

#define ALLOW_ALL    01    /* off - allow all requests
			      on  - block all requests              */
#define ALLOW_SERV   02    /* off - allow all server requests
			      on  - block all server requests per
				    per mask                        */
#define CLIENT_SYNC  04    /* off - end client sync
			      on  - start client sync               */
#define SERV_SYNC    010   /* off - end server sync
			      on  - start server sync               */
#define STARTK       020   /* on  - start kprocs
			      off - do not start kprocs             */
#define DSINITED     040   /* on  - kprocs are started (inited)
			      off - kprocs are not started (inited) */
#endif
