/* @(#)dsrw.h	7.2 88/04/19 22:29:02 */
#ifndef _h_dsrw
#ifdef __cplusplus
extern "C" {
#endif
#define _h_dsrw

#include <sys/types.h>
#include <sys/param.h>
#include <sys/inode.h>
#include <sys/flock.h>
#include <sys/dsrpc.h>
#include <sys/smode.h>


/*
 * rdwr_args: maps the arguments to the read and write system
 * calls.  A pointer to a rdwr_args structure is passed to the
 * vn_rdwr routines.
 */
struct rdwr_args {
	int     fdes;           /* file descriptor              */
	char    *cbuf;          /* pointer to user's buffer     */
	ulong   count;          /* number of bytes to transfer  */
	caddr_t ext;            /* extended i/o structure ptr   */
};

/*
 * Move structure: passed as an argument to the vn_rdwr routines.
 * Set up in dfs_read and dfs_write to avoid extra data copies.
 * Used by readi and writei.  A default mfstr which points to the
 * iomove routine is established in os/rdwr.c and may be referenced
 * with defmfp.
 */
struct mfstr {
	int (*move_fnc)();      /* routine to use for data move */
	caddr_t mvctl;          /* control struct for move_fnc  */
};

/*
 * Read/write transaction request for Distributed Services.
 *
 * This structure contains the control information that is passed from
 * client to server in a call to a dfs_read or dfs_write transaction.
 */
struct dsrw {
	fhandle_t fh;             /* file handle                  */
	off_t   offset;         /* position in file             */
	ulong   count;          /* bytes to be transferred      */
	ushort  flags;          /* flags from file block        */
	ushort  cnvctl;         /* conversation control         */
};
	
struct dsrwpkg {		/* package sent on read/write   */
	struct dsrmsg_s rm;     /* rpc control area             */
	struct dsrw rw;         /* read/write information       */
};

/*
 * Conversation control values for read and write
 */
#define START_READ      0x01
#define END_READ        0x02
#define NEW_FILE_HANDLE 0x04
#define WRITE_DONE      0x08
#define FSFULL_WARNING  0x20
#define CONFIRM_RET     0x40
#define DATA_MOVED      0x80

/*
 * Count of blocks to be read for a read ahead
 */
extern unsigned rdacount;
#define RDAMAX 16       /* maximum number of blocks to read ahead */

/* fswarn: this variable sets the threshold at which remote *
 * systems should start doing writes synchronously in order *
 * to avoid problems with full filesystems.                 */
extern unsigned fswarn;

struct dfs_slink
{
	fhandle_t	slink_fh;	/*  file handle of directory */
	int		slink_snmsz;	/*  source name size 	     */
	int		slink_tnmsz;	/*  target name size         */
};

struct dfs_rlink
{
	fhandle_t	rlink_fh;	/*  file handle of directory */
					/*  to read.                 */
	struct rlink_diruio		/*  Associated uio & iovec   */
	{
		struct	uio	uio;
		struct	iovec	iovec;
	} rlink_uio;
};


#ifdef __cplusplus
}
#endif
#endif
