/* @(#)clock.h	7.1 87/06/15 23:34:27 */
#ifndef _h_clock
#ifdef __cplusplus
extern "C" {
#endif
#define _h_clock
 
#include        <sys/low.h>

#define	SECHR	(60*60)	/* seconds/hr */
#define	SECDAY	(24*SECHR)	/* seconds/day */
#define	SECYR	(365*SECDAY)	/* seconds/common year */
/*
 * if file system date is FSDATE days old
 * the user is warned that the date may need to be reset
 */
#define FSDATE  15

#define CLLEV	4
#define CLPSB PSB4
#define CL_EN	0x80000000	/* enable timer */
#define CL_DIS	0x40000000	/* disable timer */
#define CL_SLVL	0x20000000	/* set intr. level */
#define CL_SNTV	0x10000000	/* set interval */
#define CL_ST	0x08000000	/* set current time */
#define CL_EN60	0x01000000	/* turn on locore 60 hz timer */
#define CL_START (CL_EN|CL_SLVL|CL_SNTV|CL_EN60)
#define MAXCLKINTV (HZ/10)	/* never slower than 10 times a second */

extern int	clkintv;	/* default timer interval */
extern int	nxtclkintv;	/* next value for timer interval */
extern int	deltint;	/* elasped time between timer interrupts */
extern int	clklevel;	/* clock interrupt level */
extern time_t	deltime;	/* aiws lowcore time fudge factor */
extern char	clkints;	/* run with clock interrupts */
#ifdef __cplusplus
}
#endif
#endif
