/* @(#)bioca.h	7.3 87/08/25 16:19:58 */
#ifndef _h_bioca
#define _h_bioca

/*
 *      Return codes from cfgabdds in librts 
 */

#define VRCKUNKN  -100          /* unknown - fatal                    */
#define VRCNODISK -63           /* disk not found in pcb              */
#define VRCNOADP  -62           /* no adapters found                  */
#define VRCREAD   -61           /* error reading device               */
#define VRCDVOPN  -60           /* error opening device               */
#define VRCKCORP  -50           /* corrupt file                       */
#define VRCKDEFF  -46           /* failure to install VDD info        */
#define VRCKNOBY  -45		/* no space in DDS for ddi 	      */
#define VRCKRECF  -44           /* failure to reconfigure VDD info    */
#define VRCKUNXF  -42           /* failure to install UDD info        */
#define VRCKIOPT  -35           /* invalid option specified           */
#define VRCKNOSP  -30           /* no space (NULL) from 'malloc'      */
#define VRCKIARG  -25           /* invalid argument(s) passed	      */
#define VRCKSTNF  -20           /* kaf_file parameter not found       */
#define VRCKASNF  -15           /* kaf_file parameter not found       */
#define VRCKANOP  -10           /* unable to open kaf_file            */
#define VRCKYINF  -6            /* keyword not found in file 	      */
#define VRCKYWNF  -5            /* keyword not found in file  	      */
#define VRCSUCC    0            /* success - return code              */
#define VRCKNONE   5            /* no processing required             */


/*
 *   structures for Block I/O Communication Area
 */

#define MAXUAREA 64		/* size of user control area	*/


struct biobuf			/* Buffer in buffer pool */
{
 char *poolid;			/* pointer to the buffer pool	*/
 short *buf_dir_entry;		/* address of directory entry	*/
 short size;			/* buffer size			*/
 short flag;			/* flag field			*/
 char user_ctl_area[MAXUAREA];	/* user control area		*/
 short data_length;		/* length of data (in bytes)	*/
 short data_offset;		/* offset from start of data	*/
				/*  area to data (in bytes)	*/
};

struct ring_ptrs 		/* Ring queue pointer	*/
{
 char *in;			/* ring's in pointer	*/
 char *out;			/* ring's out pointer   */
 char *end;			/* ring's end pointer   */
};

struct buf_addr			/* Ring queue's buffer address */
{
 struct biobuf *addr;
};

#endif
