/* @(#)auditk.h	1.6 88/08/30 08:55:26 */

#ifndef _H_AUDITK
#define _H_AUDITK

#include	"audit.h"

/*
 * this file describes auditing structures private to the kernel
 */

#define	MAX_ANAMES	32

/*
 * this is the format of base event entries in the kernel symbol table
 */
struct	base_events
{
	char	be_name[16];
	ulong	be_bitmap;
	struct	base_events	*be_next;
	struct	base_events	*be_prev;
};

/* global audit flag */
extern	int	audit_flag;

/* global table of base events */
extern	struct	base_events	*be_symtab;

extern	struct	file	*audit_bin;
extern	struct	file	*audit_next;
extern	int	audit_threshold;
extern	int	audit_size;
extern	int	audit_panic;
extern	int	audit_sync;

/*
 * total length of all strings and related fields associated with the 
 * base_events symbol table.  This is kept in case an audit_events
 * system call is made with the AUDIT_GET/LOCK parameter - we don't
 * want to have to recalculate all this...
 */
extern	int	be_total_len;

/*
 * determine whether auditing is enabled for an indexed event.
 * the caller must have checked:
 *	id >= 0
 * the caller is expected also to check:
 *	audit_flag
 *	u.u_auditstatus (if appropriate)
 * used by trap(), kauditlog() (below), auditlog().
 */
#define	audit_is_on(id) \
	(be_symtab[(id)].be_bitmap & u.u_procp->p_auditmask)

/*
 * write an audit record for the current system call.
 * used by audit(), exec(), exit().
 * the sequence appears explicitly in trap().
 */
#define	audit_svc() \
	{ \
		if (u.u_svcnum) \
		{ \
			if ((u.u_prependlen) || \
			    (u.u_procp->p_auditmask & be_symtab[u.u_svcnum].be_bitmap)) \
				auditscall(); \
			u.u_svcnum = 0; \
		} \
	}

/*
 * generate an "arbitrary" audit record from within the kernel
 */
#define	_auditlog(event,result,buf,len) \
	{ \
		if (audit_flag == AUDIT_ON) \
		{ \
			static int	_id; \
			if (_id == 0) \
				_id = audit_klookup(event); \
			if ( \
				(_id > 0) && \
				audit_is_on(_id) \
			   ) \
				audit_write(_id, result, buf, len); \
		} \
	}

/*
 * the format of a system call audit record is:
 *	event == svc name
 *	result == u_errror
 * the tail of a system call audit record is:
 *	rval1
 *	rval2
 *	nargs
 *	arg[0]
 *	arg[1]
 *	...
 *	npath
 *	path[0], symlink?, lookup result
 *	path[1], symlink?, lookup result
 *	...
 */

/*
 * because you can sleep when doing a write, we need a mechanism for
 * synchronizing the auditing system.  A simple locking mechanism
 * is provided (see <sys/auditk.h>).
 */
extern	int	audit_sync;

#define	AUDIT_LOCKED	1
#define	AUDIT_WANTED	2

#define	LOCK_AUDIT() \
	{ \
		while (audit_sync & AUDIT_LOCKED) \
		{ \
			audit_sync |= AUDIT_WANTED; \
			sleep(&audit_sync, PRIFBIO); \
		} \
		audit_sync = AUDIT_LOCKED; \
	}

#define	UNLOCK_AUDIT() \
	{ \
		audit_sync &= ~AUDIT_LOCKED; \
		if (audit_sync & AUDIT_WANTED) \
			wakeup(&audit_sync); \
	}


#define	TCBMOD	1
#define	TCBLEAK 2

#endif
