/* @(#)audit.h	7.9 88/09/11 13:20:29 */

#ifndef _H_AUDIT
#ifdef __cplusplus
extern "C" {
#endif
#define _H_AUDIT

/*
 * this file provides definitions for the
 * audit system call interfaces
 */

#include <sys/types.h>		/* for time_t, ... */

/*
 * commands for audit() system call
 */
#define	AUDIT_QUERY	0
#define	AUDIT_ON	1
#	define AUDIT_PANIC	1
#	define AUDIT_NO_PANIC	0
#define	AUDIT_OFF	2
#define	AUDIT_RESET	3

/*
 * commands for auditbin() system call
 */
#define AUDIT_WAIT	0x01
#define AUDIT_EXCL	0x02

/*
 * commands for auditproc() system call
 */
#define AUDIT_QEVENTS	1
#define AUDIT_EVENTS	2
#define AUDIT_QSTATUS	3
#define	AUDIT_STATUS	4

#define AUDIT_RESUME	0
#define AUDIT_SUSPEND	1

/*
 * comands for auditevents() system call
 */
#define AUDIT_GET	0
#define AUDIT_SET	1
#define AUDIT_LOCK	3

/*
 * structure for auditevents() system call
 */
struct	admin_events
{
	char	*ae_name;	/* name of this administrative event */
	char	*ae_list;	/* ptr to list of null terminated base */
				/* event names, terminated by null string */
	int	ae_len;		/* length of names in ae_list (including */
				/* all nulls) */
};


/*
 * an audit trail consists of a sequence of bins.
 * each bin starts with a bin head, and must be terminated by
 * a bin tail before other bins can be appended to the trail
 */

#define	AUDIT_MAGIC	0xf0f0
#define	AUDIT_VERSION	0

#define	AUDIT_HEAD	0
#define	AUDIT_BIN_END	1
#define	AUDIT_TRAIL	2

#define uchar	unsigned char
struct aud_bin
{
	ushort	bin_magic;
	uchar	bin_version;
	uchar	bin_tail;

	ulong	bin_len;	/* unpacked length of bin's records, if this */
				/* is non-zero, the bin has a tail record */
	ulong	bin_plen;	/* current length of bin's records (may be */
				/* packed) */
	ulong	bin_time;	/* timestamp at which head/tail was written */
	ulong	bin_reserved1;
	ulong	bin_reserved2;
};


struct aud_rec
{
/* event identification */
	char	ah_event[16];	/* event name with null terminator */
	ushort	ah_length;	/* length of tail of this record */
	uchar	ah_result;	/* 0, -1 or errno */
	uchar	ah_prepend;	/* is this a prepend record? */
	
/* user identification */
	int	ah_uid;		/* effective user id */
	int	ah_ruid;	/* real user id */
	int	ah_luid;	/* login user id */

/* process identification */
	char	ah_name[16];	/* program name with null terminator */
	short	ah_pid;		/* process id */
	short	ah_ppid;	/* process id of parent */
	time_t	ah_time;	/* write time of audit record */

/* record tail follows */
};

/*
 * TCB defines...
 */
#define	TCB_OFF		0x0
#define TCB_ON		0x1
#define	TCB_QUERY	0x2

/* audit device ioctl */
#define AIO_EVENTS	0x1

#ifdef __cplusplus
}
#endif
#endif
