/* @(#)x25_arp.h	1.3 89/01/24 18:06:16
/*
 * definitions for fake ARP for X.25
 */

struct x25_arpcom {
	struct ifnet ac_if;		/* network-visible interface */
	struct in_addr ac_ipaddr;	/* copy of ip address- XXX */
};

/*
 * Internet to ethernet address resolution table.
 */
struct	x25_arptab {
	struct	in_addr at_iaddr;	/* internet address		*/
	u_long	at_channel;		/* connexion channel		*/
	struct	x25_addr at_x25_addr;	/* X.25 address			*/
	u_short	at_length;		/* address length		*/
	u_char	at_timer;		/* minutes since last reference */
	u_char	at_flags;		/* flags			*/
	struct	mbuf *at_hold;		/* last packet until resolved/timeout */
	struct	vrm_buf *mbit_buf;	/* vrm buffer for mbit sequence */
	u_short	max_pkt_size;		/* maximum packet size 		*/
};

#ifdef KERNEL

/************************************************************************
 * MACROS for manipulating x25 arp table
 ***********************************************************************/
#define	X25TAB_NB	19	/* number of buckets */
#define	X25TAB_BSIZ	(X25_MAX_SESSIONS / X25TAB_NB)	/* bucket size */
#define	X25TAB_SIZE	X25_MAX_SESSIONS

#define	X25TAB_HASH(a)	((u_long)(a) % X25TAB_NB)

#define	X25TAB_LOOK(at,addr) {					\
	register n;						\
	at = &x25_arptab[X25TAB_HASH(addr) * X25TAB_BSIZ];	\
	for (n = 0 ; n < X25TAB_BSIZ ; n++,at++)		\
		if (at->at_iaddr.s_addr == addr)		\
			break;					\
	if (n >= X25TAB_BSIZ)					\
		at = 0;						\
}
#endif

#ifdef	KERNEL
struct	x25_arptab *x25_tnew();
#endif
