/* @(#)if_802_5.h	1.5 89/02/09 14:08:59 */
/* * if_token.h -	IBM Token Ring definitions */

#define	ACF_PRIORITY3		0x00	/* priority level 3		*/
#define	ACF_TOKEN		0x10	/* token			*/
#define	FCF_LLC_FRAME		0x40	/* for frame control field	*/
#define	RCF_ALL_BROADCAST	0x8000	/* all routes broadcast		*/
#define	RCF_LOCAL_BROADCAST	0x4000	/* single route broadcast	*/
#define	RCF_DIRECTION		0x0080	/* direction			*/
#define	RCF_FRAME0		0x0000	/*  516 max LLC pkt		*/
#define	RCF_FRAME1		0x0010	/* 1500 max LLC pkt		*/
#define	RCF_FRAME2		0x0020	/* 2052 max LLC pkt		*/
#define	RCF_FRAME3		0x0030	/* 4472 max LLC pkt		*/
#define	RCF_FRAME4		0x0040	/* 8191 max LLC pkt		*/
#define	RCF_FRAME_MASK		0x0070	/* mask for frame bits		*/
#define	RI_PRESENT		0x80	/* turn on bit 0 of byte 0 src addr */

#define	route_bytes(mac)	(((mac)->mac_rcf >> 8) & 0x1f)
#define	has_route(mac)		((mac)->mac_src[0] & RI_PRESENT)
#define	largest_frame(mac)	((mac)->mac_rcf & RCF_FRAME_MASK)
#define	is_broadcast(mac)	(has_route(mac)		\
				 && ((mac)->mac_rcf & (RCF_LOCAL_BROADCAST \
							| RCF_ALL_BROADCAST)))

/*
 * Token ring MAC header
 *
 */
struct ie5_mac_hdr {
	struct {
		u_char	Mac_acf;	/* access control field		*/
		u_char	Mac_fcf;	/* frame control field		*/
		u_char	Mac_dst[6];	/* destination address		*/
		u_char	Mac_src[6];	/* source address		*/
	} _First;
	struct {
		u_short	Mac_rcf;	/* routing control field	*/
		u_short	Mac_seg[8];	/* up to 8 segment numbers	*/
	} _Variable;
};
#define	mac_acf	_First.Mac_acf
#define	mac_fcf	_First.Mac_fcf
#define	mac_dst	_First.Mac_dst
#define	mac_src	_First.Mac_src
#define mac_rcf	_Variable.Mac_rcf
#define mac_seg	_Variable.Mac_seg

/*
 * mac_to_llc	-	given the ^ to the MAC, get to the LLC
 */
#define snd_mac_to_llc(mac)	\
	(struct ie2_llc_hdr *) (((char *) (mac)) + mac_size(mac))

#define rcv_mac_to_llc(mac)	\
	(struct ie2_llc_hdr *) ((mac) + 1)

#define	mac_size(mac)		\
	(sizeof ((mac)->_First) + (has_route((mac)) ? route_bytes((mac)) : 0))

#ifndef _802_2_LLC
#define	_802_2_LLC
/*
 * Token ring LLC header
 */
#define LLCHDR 3
struct ie2_llc_hdr {
	unsigned char	dsap;		/* DSAP				*/
	unsigned char	ssap;		/* SSAP				*/
	unsigned char	ctrl;		/* control field		*/
	unsigned char	prot_id[3];	/* protocol id			*/
	unsigned short	type;		/* type field			*/
};
#endif

#define	DSAP_INET	0xaa		/* SNAP SSAP			*/
#define	SSAP_INET	0xaa		/* SNAP DSAP			*/
#define	SSAP_RESP	0x01		/* SSAP response bit		*/
#define	CTRL_UI		0x03		/* unnumbered info		*/
#define CTRL_XID0	0xaf		/* eXchange IDentifier		*/
#define CTRL_XID1	0xbf		/* eXchange IDentifier		*/
#define	CTRL_TEST0	0xe3		/* test frame			*/
#define	CTRL_TEST1	0xf3		/* test frame			*/

#define	_802_5_TYPE_IP	0x0800		/* IP protocol */
#define _802_5_TYPE_ARP	0x0806		/* Addr. resolution protocol */

#define	_802_5_MTU	1500
#define	_802_5_MIN	(60-14)

/*
 * Token Ring Address Resolution Protocol.
 *
 * See RFC 826 for protocol description.  Structure below is adapted
 * to resolving internet addresses.  Field names used correspond to 
 * RFC 826.
 */
struct	ie5_arp {
	struct	arphdr ea_hdr;	/* fixed-size header */
	u_char	arp_sha[6];	/* sender hardware address */
	u_char	arp_spa[4];	/* sender protocol address */
	u_char	arp_tha[6];	/* target hardware address */
	u_char	arp_tpa[4];	/* target protocol address */
};
#define	arp_hrd	ea_hdr.ar_hrd
#define	arp_pro	ea_hdr.ar_pro
#define	arp_hln	ea_hdr.ar_hln
#define	arp_pln	ea_hdr.ar_pln
#define	arp_op	ea_hdr.ar_op


/*
 * Structure shared between the token ring driver modules and
 * the address resolution code.  For example, each ie5_softc
 * begins with this structure.
 */
struct	ie5_arpcom {
	struct 	ifnet ac_if;		/* network-visible interface */
	u_char	ac_traddr[6];		/* token ring hardware address */
	struct in_addr ac_ipaddr;	/* copy of ip address- XXX */
};

/*
 * Internet to token ring address resolution table.
 */
struct	ie5_arptab {
	struct	in_addr at_iaddr;	/* internet address */
	u_char	at_traddr[6];		/* token ring address */
	u_char	at_timer;		/* minutes since last reference */
	u_char	at_flags;		/* flags */
	u_short	at_rcf;			/* route control field		*/
	u_short	at_seg[8];		/* routing info			*/
	struct	mbuf *at_hold;		/* last packet until resolved/timeout */
};

/*
 * token ring RAW socket addresses
 */
struct sockaddr_802_5 {
	ushort			sa_family;	/* address family: AF_802_2 */
	struct ie5_mac_hdr	sa_mac;		/* MAC portion		    */
	struct ie2_llc_hdr	sa_llc;		/* LLC portion		    */
};

#ifdef	KERNEL
extern u_char ie5_broadcastaddr[6];
struct	ie5_arptab *ie5_arptnew();
char *ie5_sprintf();
#endif

#ifndef SIOCSARP_802_5
#define	SIOCSARP_802_5	_IOW('i', 93, struct ie5_arpreq)	/* set arp entry */
#define	SIOCGARP_802_5	_IOWR('i',94, struct ie5_arpreq)	/* get arp entry */
#define	SIOCDARP_802_5	_IOW('i', 95, struct ie5_arpreq)	/* delete arp entry */
#endif
