/* @(#)netisr.h	1.1 5/6/88 11:24:50 */
/*
 * Copyright (c) 1980, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)netisr.h	7.1 (Berkeley) 6/4/86
 */

/*
 * The networking code runs off software interrupts.
 *
 * You can switch into the network by doing splnet() and return by splx().
 * The software interrupt level for the network is higher than the software
 * level for the clock (so you can enter the network in routines called
 * at timeout time).
 */
#ifdef __vax__
#define	setsoftnet()	mtpr(SIRR, 12)
#endif

/*
 * Each ``pup-level-1'' input queue has a bit in a ``netisr'' status
 * word which is used to de-multiplex a single software
 * interrupt used for scheduling the network code to calls
 * on the lowest level routine of each protocol.
 */
#define	NETISR_RAW	0		/* same as AF_UNSPEC */
#define	NETISR_IP	2		/* same as AF_INET */
#define	NETISR_IMP	3		/* same as AF_IMPLINK */
#define	NETISR_NS	6		/* same as AF_NS */

#ifndef S5
#define	schednetisr(anisr)	{ netisr |= 1<<(anisr); setsoftnet(); }
#else
#define schednetisr(anisr)	{		\
	if (anisr == NETISR_IP) {		\
		extern struct ifqueue ipintrq;	\
						\
		wakeup(&ipintrq);		\
	}					\
	if (anisr == NETISR_RAW) {		\
		extern struct ifqueue rawintrq;	\
						\
		wakeup(&rawintrq);		\
	}					\
}
#endif

#ifndef LOCORE
#ifdef KERNEL
int	netisr;				/* scheduling bits for network */
#endif
#endif
