/* @(#)fcntl.h	7.7 90/03/06 09:47:45 */
#ifndef _h_fcntl
#ifdef __cplusplus
extern "C" {
#endif
#define _h_fcntl

/* Flag values accessible to open(2) and fcntl(2) */
/*  (The first three can only be set by open) */
#define	O_RDONLY 0
#define	O_WRONLY 1
#define	O_RDWR	 2
#define	O_NDELAY 04	/* Non-blocking I/O */
#define	O_APPEND 010	/* append (writes guaranteed at the end) */
#define O_SYNC	 020	/* synchronous write option */

/* Flag values accessible only to open(2) */
#define	O_CREAT	00400	/* open with file create (uses third open arg)*/
#define	O_TRUNC	01000	/* open with truncation */
#define	O_EXCL	02000	/* exclusive open */

/* fcntl(2) requests */
#define	F_DUPFD	0	/* Duplicate fildes */
#define	F_GETFD	1	/* Get fildes flags */
#define	F_SETFD	2	/* Set fildes flags */
#define	F_GETFL	3	/* Get file flags */
#define	F_SETFL	4	/* Set file flags */
#define	F_GETLK	5	/* Get file lock */
#define	F_SETLK	6	/* Set file lock */
#define	F_SETLKW	7	/* Set file lock and wait */

/* file segment locking set data type - information passed to system by user */
/* We already have the flock structure if this is defined */

#ifndef _h_FLOCK
struct flock {         /* all apps making syscalls(lockf,fcntl) should use this */
	short	l_type;
	short	l_whence;
	long	l_start;
	long	l_len;	
        unsigned long   l_sysid;
        short   l_pid;
};

struct k_flock {       /* this is only used for Kernel procs and lock daemon */
	short	l_type;
	short	l_whence;
	long	l_start;
	long	l_len;	
        unsigned long   l_sysid;
        short   l_pid;
	int 	l_vfs;
};

#endif
/* file segment locking types */
	/* Read lock */
#define	F_RDLCK	01
	/* Write lock */
#define	F_WRLCK	02
	/* Remove lock(s) */
#define	F_UNLCK	03


#ifdef BSD_INCLUDES
/* define Fxxx in terms of O_xxx */
#ifndef	FNDELAY	
#define	FNDELAY		O_NDELAY	/* non-blocking open */
#endif
#ifndef	FAPPEND
#define	FAPPEND		O_APPEND	/* append on each write */
#endif
#ifndef	FCREAT
#define	FCREAT		O_CREAT		/* open with file create */
#endif
#ifndef	FTRUNC
#define	FTRUNC		O_TRUNC		/* open with truncation */
#endif
#ifndef	FEXCL
#define	FEXCL		O_EXCL		/* error on create if file exists */
#endif

#ifdef BSD_COMPILE_ONLY	/* things not supported in AIX */
#define	FASYNC		00100		/* signal pgrp when data ready */
#define	F_GETOWN	5		/* get file owner, clash with F_GETLK */
#define	F_SETOWN	6		/* get file owner, clash with F_SETLK */
#endif
#endif

#ifdef __cplusplus
extern int creat (const char *, int );
extern int fcntl (int, int, ...);
extern int open (const char *, int, ...);
#endif /* defined(__cplusplus) */
#ifdef __cplusplus
}
#endif
#endif
