/*
 * Definitions for the pcomm_cmd program used inside script files.
 */

/* the commands */

#define SET		0	/* set a parameter */
#define QUERY		1	/* ask a "string" question */
#define IF		2	/* ask a binary question */
#define DIAL		3	/* dial */
#define REDIAL		4	/* redial queue */
#define EXIT		5	/* exit Pcomm */
#define CLEAR_SCREEN	6	/* clear the local screen */
#define CHG_DIR		7	/* change the local directory */
#define HANG_UP		8	/* hang up the phone */
#define PRINTER		9	/* control printer logging */
#define MODEM_BREAK	10	/* send a modem break */
#define SEND		11	/* send a file */
#define RECEIVE		12	/* recieve a file */
#define SCREEN_DUMP	13	/* dump the screen contents to a file */
#define DATA_LOG	14	/* control data logging */

/* the SET arguments */

#define BAUD		0	/* baud rate */
#define PARITY		1	/* parity (EVEN, ODD, or NONE) */
#define DATA_BITS	2	/* data bits (7 or 8) */
#define STOP_BITS	3	/* stop bits (1 or 2) */
#define DUPLEX		4	/* duplex mode (FULL or HALF) */
#define AUX		5	/* the name of the auxiliary file */
#define HOT_KEY		6	/* the "hot" key (numeric) */
#define ASCII_HOT	7	/* ascii representation of hot key */
#define FLOW_CTRL	8	/* flow control (XON/XOFF or NONE) */
#define CR_IN		9	/* send as carriage return */
#define CR_OUT		10	/* receive carriage return as */
#define LOGFILE		11	/* default log file */
#define DUMPFILE	12	/* default screen dump file */
#define STRIP		13	/* strip high bit (translate table) */
#define LOCAL_ECHO	14	/* ASCII xfer - echo locally? */
#define EXPAND		15	/* ASCII xfer - expand blank lines? */
#define CR_DELAY	16	/* ASCII xfer - carriage return delay (ms) */
#define PACE		17	/* ASCII xfer - pace the output? */
#define CR_UP		18	/* ASCII xfer - send carriage return as */
#define LF_UP		19	/* ASCII xfer - send line feed as */
#define TIMER		20	/* ASCII xfer - transfer timeout */
#define CR_DN		21	/* ASCII xfer - receive carriage return as */
#define LF_DN		22	/* ASCII xfer - receive line feed as */

/* the QUERY arguments */
#define TTY_NAME	0	/* what is the current tty? */
#define MODEM_NAME	1	/* what modem do we have? */

/* the IF arguments */

#define CONNECTED	0	/* are we connected? */
#define LOG_STATUS	1	/* status of log option */
#define PRINTER_STATUS	2	/* status of print option */

