/* @(#)vrmtimer.h	7.1 87/06/15 23:40:37 */
#ifndef _h_vrmtimer
#define _h_vrmtimer

#include "sys/types.h"
#include "sys/param.h"

/* vrmtimer.h
 *	This is the format of the vrm's Virtual Machine Timer Facility, as
 *	described on I-19 of Virtual Machine Interface, V2.7
 */

struct vrm_timer {	/* located at 0xe8 */
	long	vt_ticks; /* 16.6015ms (1/60 seconds) ticks. resets at 59 */
	long	vt_status;
	time_t	vt_time;	/* real time of day (UNIX standard time */
	time_t	vt_ipltime;	/* real time of ipl */
	long	vt_cnt;
	long	vt_vipltime;	/* virtual time since ipl */
};

extern struct vrm_timer vrm_timer;
#endif
