/* @(#)types.h	7.5 88/06/16 13:35:13 */

#ifndef _h_TYPES
#define _h_TYPES

/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)types.h	7.1 (Berkeley) 6/4/86
 */

#ifndef _TYPES_
#define	_TYPES_

/* typedefs for BSD unsigned things */
typedef	unsigned char	u_char;
typedef	unsigned short	u_short;
typedef	unsigned int	u_int;
typedef	unsigned long	u_long;

typedef	struct	_quad { long val[2]; } quad;
typedef	long	swblk_t;
#ifndef __SIZE_TYPE__
#define __SIZE_TYPE__ long unsigned int
#endif
#ifndef _GCC_SIZE_T
#define _GCC_SIZE_T
typedef __SIZE_TYPE__ size_t;
#endif

#define	NBBY	8		/* number of bits in a byte */

#ifdef	BSD_INCLUDES
/*
 * Select uses bit masks of file descriptors in longs.
 * These macros manipulate such bit fields (the filesystem macros use chars).
 * FD_SETSIZE may be defined by the user, but the default here
 * should be = NOFILE (param.h).
 */
#ifndef	FD_SETSIZE
#define	FD_SETSIZE	200
#endif

typedef long	fd_mask;
#define NFDBITS	(sizeof(fd_mask) * NBBY)	/* bits per mask */
#ifndef howmany
#define	howmany(x, y)	(((x)+((y)-1))/(y))
#endif

typedef	struct fd_set {
	fd_mask	fds_bits[howmany(FD_SETSIZE, NFDBITS)];
} fd_set;

#define	FD_SET(n, p)	((p)->fds_bits[(n)/NFDBITS] |= (1 << ((n) % NFDBITS)))
#define	FD_CLR(n, p)	((p)->fds_bits[(n)/NFDBITS] &= ~(1 << ((n) % NFDBITS)))
#define	FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & (1 << ((n) % NFDBITS)))
#define FD_ZERO(p)	bzero((char *)(p), sizeof(*(p)))

/*
 * added for general collecting of stuff
 */

/*
 * interrupt level controls
 */
#define splnet	spl6
#define splimp	spl6

#endif

#endif
/* standard AIX types.h */

typedef	struct { int r[1]; } *	physadr;
typedef long            level_t;
typedef	long		daddr_t;
typedef	char *		caddr_t;
typedef	unsigned int	uint;
typedef	unsigned short	ushort;
typedef unsigned long   ulong;
typedef	ushort		ino_t;
typedef short		cnt_t;
typedef	long		time_t;
typedef	unsigned short	uid_t;
typedef	unsigned short	gid_t;
typedef int             label_t[11];  /** regs r5 - r15 **/
typedef int             dev_t;
typedef	long		off_t;
typedef	long		paddr_t;
typedef	long		key_t;


/*
 * Possible results of Distributed
 * Services uid/gid reverse mapping.
 */
enum tagtype	{ CALLER, OTHER, SOMEONE, NO_ONE };
typedef enum tagtype	tagtype;

/* typedef for the File System Identifier (fsid) */
struct fsid {
	long	val[2];
};
typedef struct fsid fsid_t;
#define	fsid_dev	val[0]
#define	fsid_type	val[1]

/* typedef for the File Identifier (fid) */
#define FHSIZE		32
#define MAXFIDSZ	(FHSIZE - sizeof(fsid_t) - sizeof(uint))

struct fid {
	uint	fid_len;
	char	fid_data[MAXFIDSZ];
};
struct fileid {			/* this is for servers only! */
	uint	fid_len;
	ino_t	fid_ino;
	uint	fid_gen;
	char	fid_x[MAXFIDSZ - (sizeof(ino_t) + 2) - sizeof(uint)];
};
typedef struct fid fid_t;

/* typedef for the File Handle (fhandle) */
struct fhandle {
	char x[FHSIZE];		/* allows structure assignments */
};
struct filehandle {			/* this is for servers only! */
	fsid_t		fh_fsid;		/* filesystem id */
	struct fileid	fh_fid;			/* file id */
};
typedef struct fhandle fhandle_t;
#define fh_dev	fh_fsid.fsid_dev
#define fh_type	fh_fsid.fsid_type
#define fh_len	fh_fid.fid_len
#define fh_ino	fh_fid.fid_ino
#define fh_gen	fh_fid.fid_gen

#ifndef NULL
		#undef NULL
#define	NULL	0
#endif
#ifndef TRUE
#define TRUE    1
#endif
#ifndef FALSE
#define FALSE   0
#endif

#endif
