/* @(#)statfs.h	1.2 88/04/19 18:58:41 */
/*
 * statfs.h - statfs system call return structure
 */

#ifndef _h_STATFS
#define _h_STATFS

/*
 * file system statistics
 * NOTE: f_version and f_nlsdirtype are UNUSED NOW, but should be set to 0!
 * NOTE: all other reserved fields should be cleared by the vfs implementation
 */
struct statfs {
	long f_version;		/* version/type of statfs, 0 for now */
	long f_type;		/* type of info, zero for now */
	long f_bsize;		/* fundamental file system block size */
	long f_blocks;		/* total data blocks in file system */
	long f_bfree;		/* free block in fs */
	long f_bavail;		/* free blocks avail to non-superuser */
	long f_files;		/* total file nodes in file system */
	long f_ffree;		/* free file nodes in fs */
	fsid_t f_fsid;		/* file system id */
	long f_vfstype;		/* what type of vfs this is */
	long f_nlsdirtype;	/* reserved for NLS dirs later, set to 0 now! */
	long f_vfsnumber;	/* vfs indentifier number */
	long f_vfsoff;		/* reserved, for vfs specific data offset */
	long f_vfslen;		/* reserved, for len of vfs specific data */
	long f_vfsvers;		/* reserved, for vers of vfs specific data */
	char f_fname[32];	/* file system name (usually mount pt.) */
	char f_fpack[32];	/* file system pack name */
};

#endif
