/* @(#)smode.h	1.2 88/04/19 18:58:32 */

#ifndef _h_smode
#define _h_smode

#include <sys/types.h>

/*
 * Change synchronization mode request.
 *
 * This structure contains the arguments passed to the dfs_chsync
 * remote procedure by a server.
 */
struct chng_mod {
	fhandle_t cm_fh;	/* file handle                  */
	ushort  cm_mode;	/* new synchronization mode     */
	ushort  cm_type;	/* file type (inode mode field) */
	ushort  cm_tbit;	/* time bits (IUPD and IACC)    */
	off_t   cm_size;	/* file size                    */
	time_t  cm_modtime;	/* file modification time       */
	int     cm_lockcnt;	/* number of locks              */
	int     cm_flags;	/* communication field          */
};

/* cm_flags */
#define CM_TRUNC	0x01	/* file was opened with O_TRUNC */
#define CM_FIRST	0x02	/* server's first open for file */
#define OLDASYNC	0x04	/* flag indicating the old smode was ASYNC */
#define CM_ELKON	0x10	/* enforced locking has be set on */
#define CM_ELKOFF	0x20	/* enforced locking has be set off */

/*
 * Synchronization mode processing structure.
 *
 * This structure contains the arguments passed to the smode()
 * procedure by aix_open, all other calls to smode() pass in 0 
 */
struct sync_mod {
	int 	sm_nid;		/* nid that issued the open */
	int     sm_flags;	/* flags , values can be CM_TRUNC and CM_FIRST*/
};

#endif
