/* @(#)sinode.h	1.3 88/05/11 09:19:32 */
#ifndef _h_sinode
#define _h_sinode

#include "sys/types.h"

/*
 * Definition for a surrogate inode.  Very similar to a regular inode
 * minus all the disk block info.  See sys/inode.h for flag definitions.
 */
struct  sinode
{
	struct gnode si_gnode;	 /* make sinode compatible with reg inode */
	struct sinode *si_forw;  /* hash chain forw */
	struct sinode *si_back;  /* hash chain back */
	short   si_flag;	 /* inode flags */
	short   si_sflag;        /* s-mode and cache flags */
	ushort 	si_mode;	 /* permission bits and file type */
	cnt_t   si_count;        /* reference count */
	off_t   si_size;         /* size of file */
	time_t  si_mtime;        /* server modification time */
	struct filock *si_filocks;  /* locked region list */
	struct mapnode *si_mapn; /* for mapped file */
	fhandle_t si_fh;         /* file handle of real file */
	unsigned long si_nid;    /* node id of machine who holds real file */
	struct  node *si_node;   /* node structure pointer */
	int     si_reserve[2];   /* placeholder */
	unsigned long si_fhkey;  /* hash key (file handle bytes summed) */
	daddr_t	si_lastr;	 /* last block read */
	int    	si_lastra;	 /* last readahead block */
	int     si_dwqcnt;       /* count of blocks in delayed write queue */
};

#define VTOSIP(x)	((struct sinode *)((x)->v_gnode->gn_data))
#define SITOGP(x)	((struct gnode *)(x))


#endif
