/* @(#)signal.h	7.6 88/06/14 15:20:20 */
#ifndef _h_SIGNAL
#define _h_SIGNAL

#include <ieeetrap.h>

#define	NSIG	32

#define	SIGHUP	1	/* hangup */
#define	SIGINT	2	/* interrupt (rubout) */
#define	SIGQUIT	3	/* quit (ASCII FS) */
#define	SIGILL	4	/* illegal instruction (not reset when caught)*/
#define	SIGTRAP	5	/* trace trap (not reset when caught) */
#define	SIGIOT	6	/* IOT instruction (abort) */
#define	SIGDANGER 7	/* system crash imminent (maybe) - causes in robust.h */
#define	SIGFPE	8	/* floating point exception */
#define	SIGKILL	9	/* kill (cannot be caught or ignored) */
#define	SIGBUS	10	/* bus error */
#define	SIGSEGV	11	/* segmentation violation */
#define	SIGSYS	12	/* bad argument to system call */
#define	SIGPIPE	13	/* write on a pipe with no one to read it */
#define	SIGALRM	14	/* alarm clock */
#define	SIGTERM	15	/* software termination signal from kill */
#define	SIGUSR1	16	/* user defined signal 1 */
#define	SIGUSR2	17	/* user defined signal 2 */
#define	SIGCLD	18	/* death of a child */
#define	SIGPWR	19	/* power-fail restart */

#define SIGAIO  25      /* basic lan signal for asychronous i/o */
#define SIGPTY  26      /* PTY read/write availability */
#define SIGIOINT  27    /* I/O intervention required */
#define SIGGRANT  28    /* monitor mode granted */
#define SIGRETRACT 29   /* monitor mode retracted */
#define SIGSOUND  30    /* sound ack */
#define SIGMSG  31      /* data  pending */


#define	SIG_DFL		(int (*)())0
#define	SIG_IGN		(int (*)())1
#define	SIG_CATCH	(int (*)())2
#define	SIG_HOLD	(int (*)())3
#define	BADSIG		(int (*)())-1

/*
 * Signal vector "template" used in sigvec call.
 */
struct	sigvec {
	int     (*sv_handler)();/* signal handler */
	int     sv_mask;        /* signal mask to apply */
	int     sv_onstack;     /* if bit 0 set, take on signal stack */
};                              /* if bit 1 set, use old (Bell)style signals*/
/*	values in sv_onstack */
#define SIG_STK		0x00000001	/* bit for using sigstack stack */
#define SIG_STD		0x00000002	/* bit for old style signals */

#define _OLDSTYLE (2)
#define _ONSTACK  (1)
#define _teststyle(n)   ((n) & _OLDSTYLE) /** TRUE if Bell style signals. **/
#define _testonstack(n) ((n) & _ONSTACK)  /** TRUE if on user-sig stack.  **/
#define _setoldstyle(n) ((n) | _OLDSTYLE)
#define _setnewstyle(n) ((n) & ~_OLDSTYLE)
#define _setonstack(n)  ((n) | _ONSTACK)
#define _clronstack(n)  ((n) & ~_ONSTACK)

/*
 * Structure used in sigstack call.
 */
struct	sigstack {
	char	*ss_sp;			/* signal stack pointer */
	int	ss_onstack;		/* current status */
};

/*
 * Information pushed on stack when a signal is delivered.
 * This is used by the kernel to restore state following
 * execution of the signal handler.  It is also made available
 * to the handler to allow it to properly restore state if
 * a non-standard exit is performed.
 */
struct	sigcontext {
	int	sc_onstack;		/* sigstack state to restore */
	int	sc_mask;		/* signal mask to restore */
	int     sc_sp;                  /* sp to restore */
	int     sc_pc;                  /* pc to restore */
	int     sc_ps;                  /* & of regs saved/to-be-restored */
	fpvmach	*fpvmp;			/* pointer to virtual fp machine */
};

#define	ISSIG(p) \
	((p)->p_sig && ((p)->p_flag&STRC || \
	 ((p)->p_sig &~ ((p)->p_sigignore | (p)->p_sigmask))) && issig())

#ifdef	BSD_INCLUDES

/*
 * 
 *	AIX's BSD compatability signal.h file
 *	based on BSD 4.3
 */

#ifndef _H_signal.h
#define _H_signal.h

/*NOTE: AIX's signal 7 is SIGDANGER ***/
/***#define	SIGEMT	7	/* EMT instruction */
/* define SIGURG so it is treated special - ignored iff SIG_DFL */
#define	SIGURG	SIGPWR		/* urgent condition on IO channel */
/* NOTE: no SIGSTOP ***/
/* NOTE: no SIGTSTP ***/
/* NOTE: no SIGCONT ***/
#define	SIGCHLD	SIGCLD	/* to parent on child stop or exit */
/* NOTE: no SIGTTIN ***/
/* NOTE: no SIGTTOU ***/
#define	SIGIO	SIGAIO	/* input/output possible signal */
/* NOTE: no SIGXCPU ***/
/* NOTE: no SIGXFSZ ***/
/* NOTE: no SIGVTALRM ***/
/* NOTE: no SIGPROF ***/
/* NOTE: no SIGWINCH ***/
#define	SIGLOST	SIGIOT	/* sent by NFS lock daemon */

#ifdef BSD_REMAP_SIGNAL_TO_SIGVEC
#ifndef KERNEL
/* reimplement signal in terms of sigvec so it behaves like BSD */
static int	(*signal(sig,action))()
int	sig;
int	(*action)();
{
	struct sigvec in, out;
	in.sv_handler = action;
	in.sv_mask = 0;
	in.sv_onstack = 0;
	return( sigvec(sig,&in,&out ) ? (int(*)())-1 : out.sv_handler );
}
#endif
#endif /*BSD_REMAP_SIGNAL_TO_SIGVEC*/

/*
 * Macro for converting signal number to a mask suitable for
 * sigblock().
 */
#define sigmask(m)	(1 << ((m)-1))

#endif

#endif /* INCLUDE_BSD */
#endif /* _h_SIGNAL */

