/* @(#)mount.h	7.1 87/06/15 23:38:03 */
#ifndef _h_mount
#define _h_mount
#include <sys/types.h>
/*
 * Mount structure.
 * One allocated on every mount.
 */
struct	mount
{
	char	m_ronly;	/* Is this going to be mount read only? */
	char	m_rmount;	/* Is this a removable mount? */
	char	m_ropen;	/* It is removed or in place? */
	char	m_flags;	/* status */
	dev_t	m_dev;		/* device mounted */
	struct inode *m_inodp;	/* pointer to mounted on inode */
	struct buf *m_bufp;	/* buffer for super block */
	struct vnode *m_mount;	/* pointer to mount root inode */
};

#define	MFREE	0
#define	MINUSE	1
#define	MINTER	2
#define	MUPDATE	4		/* Update() in progress;
					don't hang on iput()'s */

extern struct mount mount[];
#endif
