/* @(#)loadtbl.h	1.3 88/09/08 15:58:14 */

/*
 *
 * loadtbl.h - general include file for the loadtbl system call
 */
#ifndef _h_loadtbl
#define _h_loadtbl

/*
 * loadtbl( cntl, buf, size )
 * struct ltable *cntl; args to loadtbl syscall
 * char *buf; data to/from table
 * int size; size of *buf
 */
struct ltable{
	char type;	/* the type of table being managed. (see below) */
	long id;	/* Identifies table id type (see notes below) */
	char mode;	/* Mutually exclusive values defined below. */
	long nid;	/* The nid whose tables are to be queried. */
	long reserved[4]; /* Reserved - contents are zero. */
};
 
/*
 * this structure is used when defining the tables to the system
 */
struct table_defn {
	int	tdfn_type;		/* "type" of table */
	int	(*tdfn_func)();		/* function to call */
	int	tdfn_flags;		/* permissions (unused) */
};

/*
 * defines for table "type" (names)
 *	NOTE: these ought not be bit masks, but enumerations!
 *
 * CTAB_TABLE (formerly USERTBL) - NLS user tables.
 *    Only one entry is used, the default NLCTAB.
 */
#define	CTAB_TABLE	020	/* CTAB_TABLE - NLS user tables */
#define USERTBL	CTAB_TABLE	/* its old name */
/* 
 * defines for CTAB_TABLE ltable.id 
 */
#define CTAB_DEFAULT	001	/* NLS Collate table */
#define CTABTBL	CTAB_DEFAULT	/* its old name */


/* 
 * tables for Distributed services:
 *	for DS{N,O,W}CB, the data is struct dsxlate (see <sys/dstables.h>)
 *	for DSIPC, the data is struct dsipc (see <sys/dstables.h>)
 */
#define TBL_DSNCB	01	/* DSNCB - Node Control Block */
#define DSNCB TBL_DSNCB
/* 
 * for TBL_DSNCB, ltable.id is the nid of the (remote) host, of course!
 */
#define TBL_DSOCB	02	/* DSOCB - Outbound Control Block */
#define DSOCB TBL_DSOCB 
/* 
 * for TBL_DSOCB, ltable.id is NULL 
 */
#define TBL_DSWCB	04	/* DSWCB - Wildcard Control Block */
#define DSWCB TBL_DSWCB 
/* 
 * for TBL_DSWCB, ltable.id is NULL 
 */
#define TBL_DSIPC	010	/* DSIPC - IPC key table entries */
#define DSIPC TBL_DSIPC 
/* for TBL_DSIPC, ltable.id is NULL */
 
/*
 * defines for mode (operation to be performed)
 * 	NOTE: These should be sequential integers to make switch work faster.
 */
#define L_REPLACE	01	/* The entry being loaded is either a new */
				/* one or a replacement for an existing one.*/
#define L_DELETE	02	/* Delete an entry in the table. */
#define L_QUERYT	04	/* Query id's. */
#define L_QUERYI	010	/* Query table. */

#define TDFN_NULLID	01	/* bit flag to tell loadtbl table_qt routine
				   to ignore a NULL id */

#ifdef KERNEL
/*
 * Structure definition for the kernel version of the table.
 */
struct table_entry {
	ulong id;	/* Entry id */
	ulong size;	/* Size of data for this entry */
	caddr_t pointer;/* Location of data for this entry */ 
}; 
#endif
 
#endif
