/* @(#)kcfg.h	7.2 87/10/26 14:43:20 */
#ifndef _h_kcfg
#define _h_kcfg


#define CIOC    ('C' << 8)
#define CFRSTAT (CIOC | 1)          /* get status */
#define CFDCODE (CIOC | 2)          /* define code */
#define CFDDEV  (CIOC | 3)          /* define device */
#define CFUVRM  (CIOC | 4)          /* update vrm */
#define CFUDRV  (CIOC | 5)          /* configure unix device driver */
#define CFQDEV  (CIOC | 6)          /* query device */
#define CFBUFF  (CIOC | 7)          /* initialize BIOCA and define device */

#define DEVNAME 4           /* number of bytes used for device name  */
#define MIN_MDISK   16384   /* min minidisk iodn possible */
#define MAX_MDISK   32767   /* max minidisk iodn possible */
#define DRV_TYPE    0X1     /* bit value for device driver type */
#define SHR_TYPE    0X2     /* bit value for shared device type */
#define ADD_IODN    0X1     /* bit value for add iodn option */
#define DEL_IODN    0X2     /* bit value for delete iodn option */
#define ADD_IOCN    0X1     /* bit value for add iocn option */
#define DEL_IOCN    0X2     /* bit value for delete iocn option */
#define DUP_IOCN    0X4     /* bit value for duplicate iocn option */
#define Q_HRDW      0X1     /* bit value for query for hardware info */
#define Q_DEV       0X2     /* bit value for query for device info */
#define Q_RAS       0X4     /* bit value for query for RAS info */

/*
    the following are bit patterns used when defining a minidisk
*/
#define DF_UNIX_FS  0X10        /* define as unix file system minidisk */
#define DF_UNIX_OS  0X8         /* define as unix operatins sys minidisk */
#define DF_COPROC   0X4         /* define as coprocessor minidisk */
#define DF_VRM      0X2         /* define as vrm minidisk */
#define DF_IPL      0X1         /* define as automatic ipl minidisk */


/*
    the following are bit patterns used when determining minidisk 
    characteristics
*/
#define M_LOW_POS   0X200	/* low end disk position */
#define M_MID_POS   0X100	/* middle disk position */
#define M_HIGH_POS  0X80	/* high end disk position */
#define M_NO_BAD    0X40        /* no bad block management */
#define M_PAGING    0X20	/* paging space */
#define M_UNIX_FS   0X10 	/* unix file system */
#define M_UNIX_OS   0X8		/* unix operating system */
#define M_COPROC    0X4		/* co-processor software */
#define M_VRM	    0X2		/* vrm */
#define M_AUTO_IPL  0X1		/* auto ipl */

/*
   structure needed for define code SVC  
*/
struct defcode {
    int iocn;         /* IOCN to define */
    int opts;         /* options word */
    int ciocn;        /* IOCN to copy */
};

/*
    structure needed for define device SVC
*/
struct defdev {
    unsigned short iodn;         /* IODN to use */
    unsigned short iocn;         /* IOCN to use */
    unsigned short opts;         /* add/delete */
    unsigned short chars;        /* device characteristics */
    char name[4];       /* device name */
    int spare;
    union {
	struct {
            int offhc;          /* offset to hardware characteristics */
            int offdc;          /* offset to device characteristics */
            int offras;         /* offset to RAS info */
	} offsets; 
        int ddi[1];         /* device dependent info */
    } ddi_data;
};

/*
    structure needed for send command SVC
*/
struct sc_data {
    int rv2;    
    int rv3;
    int rv4;
    int rv5;
    int rv6;
};    

/*
    structure to configure unix drivers
*/
struct unxdrv {
    dev_t   devno;      /* major/minor device number */
    unsigned short   iodn;       /* IODN to set */
    unsigned short   ddilen;     /* device dependent info length (in bytes) */
    unsigned short   lev;        /* interrupt level */
    union {
	char ddi_scs [1];
	struct sc_data ddi_sc;
    } ddi;
};

/*
    structure for query device SVC's
*/
struct qdev {
    unsigned short iodn;     /* IODN to query */
    unsigned short options;  /* Query device options */
    int length;              /* length of the following */
    char buffer[1];          /* info returned in here */
};


/*
    structure for query minidisk SVC
*/
struct qmini {
    unsigned short m_iodn;	/* iodn of minidisk */
    unsigned short r_iodn;	/* iodn of real disk */
    unsigned short chars;	/* device characteristics */
    char blsize;		/* block size */
    char spare;			/* not used */
    int sectors;		/* number of sectors */
    int blocks;		        /* number of blocks */
    char name[4];		/* name of minidisk */
    int date;			/* creation date */
};

/*
    structure for query real disk SVC
*/
struct qreal {
    unsigned short r_iodn;	/* iodn of real disk */
    unsigned short minis;	/* number of minidisks returned in qmini array*/
    int length;			/* length of real disk in sectors */
    int total;			/* total number of minidisks on the real disk */
    struct qmini qmini[50];	/* individual minidisk info */
};

struct bptr
   {
      short iodn;
      char *bioptr;
   };
extern struct bptr bptr[];
#endif
