/* @(#)flock.h	7.1.2.1 88/04/19 22:29:26 */
#ifndef _h_FLOCK
#define _h_FLOCK

/* file segment locking set data type - information passed to system by user */
/* it is also found in fcntl.h */
#ifndef	F_RDLCK

/* file segment locking types */
#define	F_RDLCK	01	/* Read lock */
#define	F_WRLCK	02	/* Write lock */
#define	F_UNLCK	03	/* Remove lock(s) */

struct	flock	{
	short	l_type;
	short	l_whence;
	long	l_start;
	long	l_len;		/* len = 0 means until end of file */
	unsigned long	l_sysid;
	short	l_pid;
};
#endif

#define INOFLCK		1	/* Inode is locked when reclock() is called. */
#define SETFLCK		2	/* Set a file lock. */
#define SLPFLCK		4	/* Wait if blocked. */

/*
** lock status
**	used to coordinate with sleeping locks
** WASBLOCK is only used for debugging
*/

#define LCK_UNBLOCK	0
#define	LCK_BLOCKER	1
#define	LCK_BLOCKED	2
#define	LCK_WASBLOCK	4

/* file locking structure (connected to inode) */

#define l_end 		l_len
#define MAXEND  	017777777777

struct	filock	{
	struct	flock	set;	/* contains type, start, and end (len) */
	struct	{
		short state;
		struct {	/* sleeping lock */
			unsigned long	sysid;
			short		pid;
			struct proc	*procp;
		} blk;
	} stat;
#ifdef	__u3b__
	sema_t		wakesem;
#endif
	struct	filock	*prev;
	struct	filock	*next;
};

/* file and record locking configuration structure */
/* record use total may overflow */
struct flckinfo {
	long recs;	/* number of records configured on system */
	long reccnt;	/* number of records currently in use */
	long recovf;	/* number of times system ran out of record locks. */
	long rectot;	/* number of records used since system boot */
	long recrsvd;	/* number of records reserved for sync mode change */
};

#define RMTLOCK 1

#define ENF_LOCK(mode)	(((mode) & (ISGID | (IEXEC >> 3))) == ISGID)

extern struct flckinfo	flckinfo;
extern struct filock	flox[];
#endif
