/* @(#)file.h	7.4 88/06/14 15:35:23 */
#ifndef _h_file
#define _h_file

#include <sys/types.h>
#include <sys/param.h>

/*
 * One file structure is allocated for each open/creat/pipe call.
 * Main use is to hold the read/write pointer associated with
 * each open file.
 */
struct	file {
	short	f_flag;
	cnt_t	f_count;	/* reference count */
	union {
		struct vnode	*f_uvnode;	/* pointer to vnode structure */
		struct file	*f_unext;	/* next entry in freelist */
	} f_up;
	union {
		off_t	f_off;	/* read/write character pointer */
		caddr_t	f_chan;	/* MPX channel pointer */
	} f_un;
	caddr_t	f_vinfo;	/* any info vfs needs, ie NFS cred, DS nodep */ 
	off_t	f_dir_off;	/* BSD style directory offsets */
};

#define	f_data		f_up.f_uvnode
#define	f_vnode		f_up.f_uvnode
#define	f_next		f_up.f_unext
#define	f_offset	f_un.f_off
#define	f_channel	f_un.f_chan
#define f_nodep		f_vinfo;

extern struct file file[];	/* The file table itself */
extern struct file *ffreelist;	/* Head of freelist pool */

/* flags */
#define	FOPEN	(-1)
#define	FREAD	00001
#define	FWRITE	00002
#ifndef BSD_INCLUDES	/* these are defined in fcntl.h for BSD */
#define	FNDELAY	00004
#define	FAPPEND	00010
#endif
#define	FSYNC	00020
#define	FMPX	00200	/* multiplexed open */
#define	FMASK	00377

/* FFCNTL is all the bits that may be set via fcntl. */
/* Note that LKL wants FSYNC left in for now - 10/24/85 CSM */
#define	FFCNTL	(FNDELAY|FAPPEND|FSYNC) 

#ifndef BSD_INCLUDES	/* these are defined in fcntl.h for BSD */
/* open only modes */
#define	FCREAT	00400
#define	FTRUNC	01000
#define	FEXCL	02000
#endif

/* additional modes */
#define	FEXEC	00040		/* open/close for exec */
#define	FFULL	0x8000		/* fullsync flag for remote write */

#ifdef BSD_INCLUDES
/* 
 * file.h - BSD to AIX porting tools include file
 */

/* additional BSDisms that will work in AIX */
/*
 * Access call.
 */
#define	F_OK		0	/* does file exist */
#define	X_OK		1	/* is it executable by caller */
#define	W_OK		2	/* writable by caller */
#define	R_OK		4	/* readable by caller */

/*
 * Lseek call.
 */
#define	L_SET		0	/* absolute offset */
#define	L_INCR		1	/* relative to current offset */
#define	L_XTND		2	/* relative to end of file */

/* and just get the fcntl stuff from fcntl.h */
#include  <fcntl.h>
/* END Include of AIX /usr/include/fcntl.h */


#endif

#endif
