/* @(#)erec.h	7.3 88/01/12 08:04:20 */
/* Changes:
	4/16/85 Added E_SYS to E_UNIX subclass to give errdemon something
		to log under.
*/

/*
 * Every error record has a header as follows.
 */
#ifndef _h_EREC
#define _h_EREC

#ifndef time_t
#define time_t	long
#endif

struct errhdr {
	unsigned e_len;		/* bytes in record (with header) */
	time_t	e_time;		/* time of day */
	long	e_timex;	/* clock ticks */
	char	e_nid[8];	/* Node ID */
	char	e_vmid[8];	/* Virtual Machine ID */
	union {
		struct {
			char	ex_class;
			char	ex_subclass[2];
			char	ex_type;	/* record type */
		} ex;
		int csmt;
	} exx;
};
#define e_class		exx.ex.ex_class
#define e_subclass	exx.ex.ex_subclass
#define e_type		exx.ex.ex_type
#define e_csmt		exx.csmt
/* used to construct csmt */
#define MKWORD(a,b,c,d) (((((((a)<<8) | (b)) <<8) | (c)) <<8) | (d)) 

 /*
  * bits in the type fields
  */
#define E_PERM	0x80
#define E_TMP	0x40
#define E_INFO	0x20
#define E_CNTR  0x10
#define E_ABR	0x8
#define E_ANAL	0x1

/*
 * Error classes
 */

#define E_HARDWARE	1
#define E_SOFTWARE	2
#define E_IPL		3
#define	E_GENERAL	4
#define	E_USER		6

/*
 *	subclasses
 *
 */

/* Hardware */

#define E_PROCMC	01		/* Processor machine check */
#define		E_MP		01	/* main processor */
#define 	E_MM		02	/* main memory */

#define	E_DISK		02		/* Hard file and adaptor */
#define E_FLOP		03		/* diskette drive and adaptor */
#define E_TAPE		04		/* tape drive and adaptor */
#define E_DISPA		05 		/* display station and adaptor */
#define E_DISP		06		/* display station */
#define E_MOUSE		07		/* keyboard/mouse */
#define E_COMMA		0x08		/* communication adaptor */
#define		E_RS232a	 1	/* rs-232 multi port */
/*				 2	   reserved		*/
#define		E_SSP		 4	/* serial of serial/parallel */
#define		E_HPCNETWORK	 5
#define		E_RS422		 6	/* rs422 multi-port */
#define 	E_NSIO		 7	/* native serial io */
#define		E_MPASYNC	 8	/* multi protocol async */
#define		E_MPBISYNC	 9	/* multi protocol bisync */
#define		E_MPSDLC	10	/* multi protocol sdlc */
#define		E_MPHDLC	11	/* multi protocol hdlc */
#define		E_MPR366	12	/* RS366 */
#define	E_PPRINT	 9		/* parallel printer adaptor */
#define		E_PPA		01	/* parallel of serial/parallel */
#define		E_PPCM		0x02	/* parallel of PC monochrome */
#define	E_PRINTERS	10	/* other printers */
#define E_COPROC	11	/* Co-Processor */

/* Software */
#define E_PROCPC	01	/* Processor Program check */
#define E_ABEND        02     /* Abend */
#define		E_ADT		01	/* Dump Taken */
#define		E_ANDT		02	/* No dump Taken */
/* Program Error */
#define E_UNIX          03      /* UNIX */
#define         E_KERN          03      /* Unix Kernel */
#define         E_SYS           04      /* Unix System Application */
#define E_UNIXDD1       04      /* UNIX Device Drivers */
#define 	E_GBIODD       04      /* AIX block I/O device driver */
#define E_UNIXDD2       05      /* UNIX Device Drivers */
#define E_VRMBASE       06      /* VRM Base */
#define E_VRMCOMP       07      /* VRM COMP */
#define E_APPL          0x08      /* Applications */
#define         E_EPD           01      /* Error Problem Determination */
#define         E_IWS           02      /* Interactive Workstation */
#define         E_VTRM          03      /* Virtual Terminal */
#define         E_TRD           07      /* Token Ring Diagnostic */

/* BOOT / Shutdown */
#define E_MANIPL	01	/* Manual IPL */
#define E_SOFTIPL	02	/* Soft IPL */
#define E_SHUTDOWN	04	/* Shutdown */
#define E_MAINT   	05	/* Maintenance */
#define E_MULTI         06      /* Multi-user */

/* General System */

#define E_DEGRADE	01	/* Degraded Configuration */
#define E_CHGTIM	02	/* Set Time / date */

/*	User defined
 *		01 - 255
 */

/*
 * Error log hardware error record: class E_HARDWARE
 */

struct e_hardware {
	unsigned short  e_iodn, e_iocn;
	unsigned long   e_baseioaddr;   /* Base I/O port address */
	unsigned long   e_devname;      /* device name */
	unsigned long   e_idevtype;     /* internal device type */
	unsigned long   e_length;       /* length of ddd */
	unsigned long   e_ddd[1];       /* device dependent data begins here */
};


/* 
 * Error log software error records: class E_SOFTWARE;
 * Identical to struct eabend with added length field.
 */

struct e_abend {
	unsigned long   len;    /* Length of entry */
	int     CAMP;   /* comp. ID, abend code, mach. status, pgm status */
	int     curid;  /* current ID @ abend time */
	int     IAR;
	union {
		int i;
		struct {
			short   ICS;
			char    a_type; /* 1=HW, 2=SW, 3=VM */
			char    CS;
		} sc;
	} iac;
};
 struct e_progerr {
	unsigned long   len;    /* Length of entry */
	unsigned char   amid[8]; /* Module identifier */
	unsigned long   rtcode;         /* return code */
	unsigned long   data[16];       /* data */
};


/*
 *	IPL / shutdown record
 */


struct estart {
	long e_len;
	char e_state;
	char e_diag;		/* from nvram */
	char e_machtype;	/* Machine type */
	char e_nvram_valid;	/* nvram valid  */
	long e_iplaa;		/* ipl adaptor address */
	long e_time;		/* ipl time */
	struct  {	/* from uname */
		char e_sysname[8];
		char e_nodename[8];
		char e_release[8];
		char e_version[8];
		char e_machine[8];
	} e_id;
};

/* e_state bits */
#define D_MANIPL	0x80	/* Manual IPL */
#define D_SOFTIPL	0x40	/* Soft/auto IPL */
#define D_SHUTDOWN	0x10	/* Shutdown */

/*

/*
 * A time change record is sent to the daemon whenever
 * the system's time of day is changed.
 */

struct etimchg {
	long	e_len;
	time_t	e_otime;	/* old time */
	time_t	e_ntime;	/* new time */
};

/*
 * vrm abend record as stored in NVRAM 
 */
struct eabend {
	int     CAMP;   /* comp. ID, abend code, mach. status, pgm status */
	int     curid;  /* current ID @ abend time */
	int     IAR;
	union {
		int i;
		struct {
			short   ICS;    /* interrupt cntl status reg */
			char    abend_type; /* 1=HW, 2=SW, 3=VM */
			char    CS;     /* condition status */
		} sc;
	} iac;
};

/*
 * unix panic record, gotten from nvram
 */
struct epanic {
	int	e_len;
	long	e_panicstr[1];	/* first byte of panic string */
};
#endif
