/* @(#)dsmisc.h	1.2 88/07/16 18:03:49 */

#ifndef _h_dsmisc
#define _h_dsmisc

#include <sys/types.h>
#include <sys/vnode.h>

extern network_vtype[14];
extern vtype_5a[14];

#define NETWORK_VTYPE(type) 	network_vtype[type]

#define VTYPE_5A(net_type)	vtype_5a[net_type]

#define DSMAXNAMLEN 256
/*
 * Structure describing the attributes of files across all
 * the types of file systems which are supported.  This is
 * a superset of the AIX stat structure's fields.
 */
struct vattr50
{
	enum 	vtype	va_type;		/* vnode type		*/
	short	va_mode;		/* access mode			*/
	short	va_uid;			/* owner uid			*/
	short	va_gid;			/* owner gid			*/
	long	va_nid;			/* node id			*/
	short	va_nlink;		/* number of links		*/
	long	va_size;		/* file size in bytes		*/
	long	va_wireuid;		/* network-wide uid		*/
	time_t	va_atime;		/* time of last access		*/
	time_t	va_mtime;		/* time of last data		*/
					/*   modification		*/
	time_t	va_ctime;		/* time of last status change	*/
	dev_t	va_rdev;		/* id of device			*/
	long	va_wiregid;		/* network-wide gid		*/

	int	xva_dev;		/* id of device containing this	*/
					/*   file			*/
	long	va_serialno;		/* file serial number		*/

	/* Fields added for compatability with the fullstat structure */
	ushort	va_uid_raw;
	ushort	va_gid_raw;
	tagtype	va_uid_rev_tag;
	tagtype	va_gid_rev_tag;
	short	va_other_uid;
	short	va_other_gid;
	short *	va_other_gid_list;
	short	va_other_gid_count;

	long	va_mapflag; 		/* Records whatever uid/gid	*/
					/*   mapping took place during	*/
					/*   getattr.			*/
};

struct diropres50 {
	fhandle_t	file;
	struct vattr50	vattr50;
	int		mode;
};

struct gattr_response_50  {
	struct 	vattr50	v;
};

struct ds_args {
	ulong	nid;
};

#endif
