/* @(#)debug.h	7.2 87/09/25 15:54:34 */
#ifndef _h_debug
#define _h_debug

/* Generalized debug field; one per procedure                             */
/* Note that while dfdata is a word-aligned structure                     */
/* a debug field need not be word-aligned.                                */

struct dfdata {
	unsigned char df1;      /* always DFMAGIC                         */
	unsigned char code;     /* debug code field                       */
	unsigned char df2;      /* always DFMAGIC                         */
	unsigned char flags;    /* depends on code                        */
	union {
	    short _framesize;   /* D_NORMAL: size of this proc's frame    */
	    long  _bigframe;    /* D_BIGFRAME                             */
		  /* high order 4 bits = lowest fp register pair saved;   */
		  /* in range 0-5; use 6 if no fp registers are saved.    */
	} _data;
};
#define framesize	_data._framesize
#define bigframe	_data._bigframe

#define DFMAGIC         0xdf

/* debug codes */

#define D_ERROR         0       /* can't find debug data                  */
#define D_NORMAL        1       /* normal c-like debug data               */
#define D_NOFRAME       2       /* assembler routine w/no frame           */
#define D_START         3       /* debug data of "start" proc             */
#define D_SIGNAL        4       /* debug data of signal frame             */
#define D_NOARGS        5       /* assembler routine no args or frame     */
#define D_BIGFRAME      6       /* if fp regs saved or framesize > 0x7fff */
#define D_BIGNO15       7       /* BIGFRAME without reg 15 saved          */
#define D_NORMNO15      8       /* NORMAL without reg 15 saved            */
#define D_NOFRAMESAVE   9	/* No frame, but registers saved 	  */

/*  When code is D_NORMAL or D_BIGFRAME                                   */
/*      flags = xxxx1234                                                  */
/*              xxxx      lowest register saved                           */
/*                  1234  on  if nth argument is in saved in a register   */
/*                        off if nth argument is on stack                 */
/*                                                                        */
/*  Arguments saved in registers are assigned sequentially down from 13.  */
/*  If flags = 10010101, r9-r15 are saved, r13 holds arg2, r12 holds arg4.*/
#endif
