/* @(#)conf.h	7.2 88/05/13 10:03:28 */

#ifndef _h_conf
#define _h_conf

#if 0   /** if separate block and device tables **/
/*
 * Declaration of block device switch. Each entry (2 rows) is
 * the only link between the main unix code and the driver.
 * The initialization of the device switches is in the file conf.c.
 */
struct bdevsw {
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_strategy)();
	int	(*d_print)();
};
extern struct bdevsw bdevsw[];

/*
 * Character device switch.
 */
struct cdevsw {
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_read)();
	int	(*d_write)();
	int	(*d_ioctl)();
	struct tty *d_ttys;
};
extern struct cdevsw cdevsw[];

#else   /** if joined block and character device tables  **/
/*
 * device switch table
 */
struct devsw {
	int     (*d_open)();
	int     (*d_close)();
	int     (*d_strategy)();
	int     (*d_read)();
	int     (*d_write)();
	int     (*d_ioctl)();
	unsigned short *iodns;
	struct tty *d_ttys;
	int     (*d_print)();
	int     (*d_dinit)();
	int     *d_opencnt;
	int	(*d_select)();
	int	(*d_mpx)();
	int	(*d_revoke)();
};
extern struct devsw devsw[];

#endif

#if 0   /**  old references  **/
extern int	bdevcnt;
extern int	cdevcnt;
#else
extern int      devcnt;
#endif

/*
 * Line discipline switch.
 */
struct linesw {
	int	(*l_open)();
	int	(*l_close)();
	int	(*l_read)();
	int	(*l_write)();
	int	(*l_ioctl)();
	int	(*l_input)();
	int	(*l_output)();
	int	(*l_mdmint)();
};
extern struct linesw linesw[];

extern int	linecnt;
/*
 * Terminal switch
 */
struct termsw {
	int	(*t_input)();
	int	(*t_output)();
	int	(*t_ioctl)();
};
extern struct termsw termsw[];

extern int	termcnt;
#endif
