#ifndef _PARAMS
#if defined(__STDC__) || defined(__cplusplus)
#define _PARAMS(ARGS) ARGS
#else
#define _PARAMS(ARGS) ()
#endif
#endif /* _PARAMS */
#define __need___va_list
#include <stdarg.h>
/* @(#)stdio.h	7.1 - 87/06/16 - 00:13:13 */
#ifndef _h_STDIO
#define _h_STDIO

/* For Dynamic iob's. Make sure _NFILE is
  a multiple of _NIOBRW (IOB Row).
*/
#define _NFILE	200
#define _NIOBRW	20
#define _NRWS	(_NFILE / _NIOBRW )+1

			/* Number of iob rows should be equal
			   to (_NFILE / _NIOBRW ) + 1.  The extra
			   row ensures insures that the _NFILE+1th
			   fopen fails because of open(). 
			 */

#define BUFSIZ	2048
#ifndef BUFSIZ
#define BUFSIZ	512
#endif

/* buffer size for multi-character output to unbuffered files */
#define _SBFSIZ 8

typedef struct {
	unsigned char	*_ptr;
	int	_cnt;
	unsigned char	*_base;
	unsigned char   *_bufendp;
	short	_flag;
	short	_file;
	int	_unused[3];
} FILE;

/*
 * _IOLBF means that a file's output will be buffered line by line
 * In addition to being flags, _IONBF, _IOLBF and _IOFBF are possible
 * values for "type" in setvbuf.
 */
#define _IOFBF		0000
#define _IOREAD		0001
#define _IOWRT		0002
#define _IONBF		0004
#define _IOMYBUF	0010
#define _IOEOF		0020
#define _IOERR		0040
#define _IOLBF		0100
#define _IORW		0200
#define	_IONOFD		0400

#ifndef NULL
		#undef NULL
#define NULL		0
#endif
#ifndef EOF
#define EOF		(-1)
#endif

#define stdin		(&_iob[0])
#define stdout		(&_iob[1])
#define stderr		(&_iob[2])

#define _bufend(p)	((p)->_bufendp)
#define _bufsiz(p)	(_bufend(p) - (p)->_base)

#ifndef lint
#define getc(p)		(--(p)->_cnt < 0 ? _filbuf(p) : (int) *(p)->_ptr++)
#define putc(x, p)	(--(p)->_cnt < 0 ? \
			_flsbuf((unsigned char) (x), (p)) : \
			(int) (*(p)->_ptr++ = (unsigned char) (x)))
#define getchar()	getc(stdin)
#define putchar(x)	putc((x), stdout)
#define clearerr(p)	((void) ((p)->_flag &= ~(_IOERR | _IOEOF)))
#define feof(p)		((p)->_flag & _IOEOF)
#define ferror(p)	((p)->_flag & _IOERR)
#define fileno(p)	(p)->_file
#endif

extern FILE	_iob[_NIOBRW];
extern FILE	*fopen _PARAMS((const char *, const char *)), *fdopen _PARAMS((int, const char *)), *freopen _PARAMS((const char *, const char *, FILE *)), *popen _PARAMS((const char *, const char *)), *tmpfile();
extern long	ftell _PARAMS((FILE *));
extern void	rewind _PARAMS((FILE *)), setbuf _PARAMS((FILE *, char *));
extern char	*ctermid _PARAMS((char *)), *cuserid _PARAMS((char *)), *fgets _PARAMS((char *, int, FILE *)), *gets _PARAMS((char *)), *tempnam _PARAMS((const char *, const char *)), *tmpnam _PARAMS((char *));

#define L_ctermid	9
#define L_cuserid	9
#define P_tmpdir        "/tmp/"
#define L_tmpnam	(sizeof(P_tmpdir) + 15)
#endif
#if defined(__cplusplus) || defined(__USE_FIXED_PROTOTYPES__)
extern int fclose (FILE *);
extern int fflush (FILE *);
extern int fgetc (FILE *);
extern int fgetpos (FILE *, long *);
extern int fprintf (FILE *, const char *, ...);
extern int fputc (int, FILE *);
extern int fputs (const char *, FILE *);
extern __SIZE_TYPE__ fread (void *, __SIZE_TYPE__ , __SIZE_TYPE__ , FILE *);
extern int fscanf (FILE *, const char *, ...);
extern int fseek (FILE *, long int, int);
extern int fsetpos (FILE *, const long *);
extern __SIZE_TYPE__ fwrite (const void *, __SIZE_TYPE__ , __SIZE_TYPE__ , FILE *);
extern int pclose (FILE *);
extern void perror (const char *);
extern int printf (const char *, ...);
extern int puts (const char *);
extern int remove (const char *);
extern int rename (const char *, const char *);
extern int scanf (const char *, ...);
extern int setvbuf (FILE *, char *, int, __SIZE_TYPE__ );
extern int sprintf (char *, const char *, ...);
extern int sscanf (const char *, const char *, ...);
#ifndef vprintf
extern int vprintf (const char *, __gnuc_va_list);
#endif
#ifndef vsprintf
extern int vsprintf (char *, const char *, __gnuc_va_list);
#endif
#ifndef vfprintf
extern int vfprintf (FILE *, const char *, __gnuc_va_list);
#endif
extern int ungetc (int, FILE *);
extern int _flsbuf (unsigned int, FILE *);
extern int _filbuf (FILE *);
#endif /* defined(__cplusplus) || defined(__USE_FIXED_PROTOTYPES__*/
