/* @(#)if_802_3.h	1.3 89/02/09 14:08:53 */
/*
 * if_802_3.h -	Address Resolution Protocol for IEEE 802.3: definitions
 */

/*
 * 802.3 MAC header
 */
struct ie3_mac_hdr {
	u_char	mac_dst[6];	/* destination address		*/
	u_char	mac_src[6];	/* source address		*/
	u_short	mac_len;	/* frame length			*/
};

#ifndef _802_2_LLC
#define	_802_2_LLC
/*
 * Token ring LLC header
 */
#define LLCHDR 3
struct ie2_llc_hdr {
	unsigned char	dsap;		/* DSAP				*/
	unsigned char	ssap;		/* SSAP				*/
	unsigned char	ctrl;		/* control field		*/
	unsigned char	prot_id[3];	/* protocol id			*/
	unsigned short	type;		/* type field			*/
};
#endif

#define	DSAP_INET	0xaa		/* SNAP SSAP			*/
#define	SSAP_INET	0xaa		/* SNAP DSAP			*/
#define	SSAP_RESP	0x01		/* SSAP response bit		*/
#define	CTRL_UI		0x03		/* unnumbered info		*/
#define CTRL_XID0	0xaf		/* eXchange IDentifier		*/
#define CTRL_XID1	0xbf		/* eXchange IDentifier		*/
#define	CTRL_TEST0	0xe3		/* test frame			*/
#define	CTRL_TEST1	0xf3		/* test frame			*/

#define	_802_3_TYPE_IP	0x0800		/* IP protocol */
#define _802_3_TYPE_ARP	0x0806		/* Addr. resolution protocol */

/*
 * The _802_3_TYPE_NTRAILER packet types starting at _802_3_TYPE_TRAIL have
 * (type-_802_3_TYPE_TRAIL)*512 bytes of data followed
 * by an _802_3_ type (as given above) and then the (variable-length) header.
 */
#define	_802_3_TYPE_TRAIL		0x1000		/* Trailer packet */
#define	_802_3_TYPE_NTRAILER	16

#define	_802_3_MTU	1500
#define	_802_3_MIN	60

/*
 * Token Ring Address Resolution Protocol.
 *
 * See RFC 826 for protocol description.  Structure below is adapted
 * to resolving internet addresses.  Field names used correspond to 
 * RFC 826.
 */
struct	ie3_arp {
	struct	arphdr ea_hdr;	/* fixed-size header */
	u_char	arp_sha[6];	/* sender hardware address */
	u_char	arp_spa[4];	/* sender protocol address */
	u_char	arp_tha[6];	/* target hardware address */
	u_char	arp_tpa[4];	/* target protocol address */
};
#define	arp_hrd	ea_hdr.ar_hrd
#define	arp_pro	ea_hdr.ar_pro
#define	arp_hln	ea_hdr.ar_hln
#define	arp_pln	ea_hdr.ar_pln
#define	arp_op	ea_hdr.ar_op


/*
 * Structure shared between the ethernet driver modules and
 * the address resolution code.  For example, each ie3_softc
 * begins with this structure.
 */
struct	ie3_arpcom {
	struct 	ifnet ac_if;		/* network-visible interface */
	u_char	ac_enaddr[6];		/* ethernet hardware address */
	struct in_addr ac_ipaddr;	/* copy of ip address- XXX */
};

/*
 * Internet to ethernet address resolution table.
 */
struct	ie3_arptab {
	struct	in_addr at_iaddr;	/* internet address */
	u_char	at_enaddr[6];		/* ethernet address */
	u_char	at_timer;		/* minutes since last reference */
	u_char	at_flags;		/* flags */
	struct	mbuf *at_hold;		/* last packet until resolved/timeout */
};

struct sockaddr_802_3 {
	ushort			sa_family;	/* address family: AF_802_3 */
	struct ie3_mac_hdr	sa_mac;		/* MAC portion		    */
	struct ie2_llc_hdr	sa_llc;		/* LLC portion		    */
};

#ifdef	KERNEL
extern u_char ie3_broadcastaddr[6];
struct	ie3_arptab *ie3_arptnew();
char *ie3_sprintf();
#endif

/*
 * missing from ioctl.h
 */
#ifndef	SIOCSARP_802_3
#define	SIOCSARP_802_3	_IOW('i', 96, struct ie3_arpreq)	/* set arp entry */
#define	SIOCGARP_802_3	_IOWR('i',97, struct ie3_arpreq)	/* get arp entry */
#define	SIOCDARP_802_3	_IOW('i', 98, struct ie3_arpreq)	/* delete arp entry */
#endif
