#ifndef _PARAMS
#if defined(__STDC__) || defined(__cplusplus)
#define _PARAMS(ARGS) ARGS
#else
#define _PARAMS(ARGS) ()
#endif
#endif /* _PARAMS */
/* @(#)math.h	7.2 - 88/10/11 - 11:50:51 */

#ifdef _C_func
#include <_C_func.h>
#endif

extern int errno, signgam;

extern double atof _PARAMS((const char *)), frexp _PARAMS((double, int *)), ldexp _PARAMS((double, int)), modf _PARAMS((double, double *));
extern double j0 _PARAMS((double)), j1 _PARAMS((double)), jn _PARAMS((int, double)), y0 _PARAMS((double)), y1 _PARAMS((double)), yn _PARAMS((int, double));
extern double erf _PARAMS((double)), erfc _PARAMS((double));
extern double exp _PARAMS((double)), log _PARAMS((double)), log10 _PARAMS((double)), pow _PARAMS((double, double)), sqrt _PARAMS((double));
extern double floor _PARAMS((double)), ceil _PARAMS((double)), fmod _PARAMS((double, double)), fabs _PARAMS((double));
extern double gamma _PARAMS((double));
extern double hypot _PARAMS((double, double));
struct exception;
extern int matherr _PARAMS((struct exception *));
extern double sinh _PARAMS((double)), cosh _PARAMS((double)), tanh _PARAMS((double));
extern double sin _PARAMS((double)), cos _PARAMS((double)), tan _PARAMS((double)), asin _PARAMS((double)), acos _PARAMS((double)), atan _PARAMS((double)), atan2 _PARAMS((double, double));
extern double copysign _PARAMS((double, double));

#include <values.h>

/* Note: HUGE should be INF. Change this as soon as the compilers can   */
/*       understand INF as input.                                       */
#define HUGE       MAXDOUBLE
#define MAXFLOAT   ((float)3.40282346638528860e+38)

/*
 *      Useful mathmatical constants:
 *
 * M_E          - e
 * M_LOG2E      - log2(e)
 * M_LOG10E     - log10(e)
 * M_LN2        - ln(2)
 * M_PI         - pi
 * M_2PI        - 2*pi
 * M_PI_2       - pi/2
 * M_PI_4       - pi/4
 * M_1_PI       - 1/pi
 * M_2_PI       - 2/pi
 * M_2_SQRTPI   - 2/(sqrt(pi)
 * M_SQRT2      - sqrt(2)
 * M_SQRT_2     - 1/sqrt(2)
 *
 */
#define M_E        2.7182818284590452354E0  /*Hex  2^ 0 * 1.5bf0a8b145769 */
#define M_LOG2E    1.4426950408889633870E0  /*Hex  2^ 0 * 1.71547652B82FE */
#define M_LOG10E   4.3429448190325181667E-1 /*Hex  2^-2 * 1.BCB7B1526E50E */
#define M_LN2      6.9314718055994530942E-1 /*Hex  2^-1 * 1.62E42FEFA39EF */
#define M_LN10     2.3025850929940456840E0  /*Hex  2^ 1 * 1.26bb1bbb55516 */
#define M_PI       3.1415926535897931160E0  /*Hex  2^ 1 * 1.921FB54442D18 */
#define M_2PI      6.2831853071795862320E0  /*Hex  2^ 2 * 1.921FB54442D18 */
#define M_PI_2     1.5707963267948965580E0  /*Hex  2^ 0 * 1.921FB54442D18 */
#define M_PI_4     7.8539816339744827900E-1 /*Hex  2^-1 * 1.921FB54442D18 */
#define M_1_PI     3.1830988618379067154E-1 /*Hex  2^-2 * 1.45f306dc9c883 */
#define M_2_PI     6.3661977236758134308E-1 /*Hex  2^-1 * 1.45f306dc9c883 */
#define M_2_SQRTPI 1.1283791670955125739E0  /*Hex  2^ 0 * 1.20dd750429b6d */
#define M_SQRT2    1.4142135623730951455E0  /*Hex  2^ 0 * 1.6A09E667F3BCD */
#define M_SQRT1_2  7.0710678118654752440E-1 /*Hex  2^-1 * 1.6a09e667f3bcd */

#define _ABS(x)	((x) < 0 ? -(x) : (x))

#define _REDUCE(TYPE, X, XN, C1, C2)	{ \
	double x1 = (double)(TYPE)X, x2 = X - x1; \
	X = x1 - (XN) * (C1); X += x2; X -= (XN) * (C2); }

#define _POLY1(x, c)	((c)[0] * (x) + (c)[1])
#define _POLY2(x, c)	(_POLY1((x), (c)) * (x) + (c)[2])
#define _POLY3(x, c)	(_POLY2((x), (c)) * (x) + (c)[3])
#define _POLY4(x, c)	(_POLY3((x), (c)) * (x) + (c)[4])
#define _POLY5(x, c)	(_POLY4((x), (c)) * (x) + (c)[5])
#define _POLY6(x, c)	(_POLY5((x), (c)) * (x) + (c)[6])
#define _POLY7(x, c)	(_POLY6((x), (c)) * (x) + (c)[7])
#define _POLY8(x, c)	(_POLY7((x), (c)) * (x) + (c)[8])
#define _POLY9(x, c)	(_POLY8((x), (c)) * (x) + (c)[9])

struct exception {
	int type;
	char *name;
	double arg1;
	double arg2;
	double retval;
	};

#define 	DOMAIN		01
#define		SING		02
#define		OVERFLOW	03
#define		UNDERFLOW	04
#define		TLOSS		05
#define		PLOSS		06


/* The following definitions were brought here from the System V   */
/*      version of values.h, to allow libm to build correctly.     */
/* Were they really? The System V values.h I have doesn't contain  */
/*      these values.                                              */ 

/* This is the nearest number to the cube root of MAXDOUBLE that   */
/*      doesn't cause the cube of it to overflow.                  */
/* In double precision hex this constant is: 554428a2 f98d728a     */
#define CUBRTHUGE      5.6438030941223618e102
#define INV_CUBRTHUGE  1.7718548704178434e-103
