#ifndef _PARAMS
#if defined(__STDC__) || defined(__cplusplus)
#define _PARAMS(ARGS) ARGS
#else
#define _PARAMS(ARGS) ()
#endif
#endif /* _PARAMS */
/* @(#)dirent.h	1.4 88/10/17 15:58:54 */
/*
 * POSIX like dirent.h
 *
 */
/* NOTE: this should go to <limits.h> for true POSIX */
#define NAME_MAX 255

#undef DIRSIZ
#define DIRSIZ(dp) \
    ((sizeof (struct dirent) - (NAME_MAX+1)) + (((dp)->d_namlen+1 + 3) &~ 3))
/*
 * The POSIX standard way of returning directory entries is in directory entry
 * structures, which are of variable length.  Each directory entry has
 * a struct direct at the front of it, containing its inode number,
 * the length of the entry, and the length of the name contained in
 * the entry.  These are followed by the name padded to a 4 byte boundary
 * with null bytes.  All names are guaranteed null terminated.
 * The maximum length of a name in a directory is NAME_MAX.
 */
struct	dirent {
	ulong	d_ino;			/* inode number of entry */
	ushort	d_reclen;		/* length of this record */
	ushort	d_namlen;		/* length of string in d_name */
	char	d_name[NAME_MAX + 1];	/* name must be no longer than this */
};

#ifndef KERNEL
/*
 * Definitions for library routines operating on directories.
 */
typedef struct _dirdesc {
	int	dd_fd;		/* file descriptor of directory */
	long	dd_loc;		/* offset within current buffer */
	long	dd_size;	/* size of buffer */
	long	dd_flag;	/* private flags for readdir */
	int	dd_blksize;	/* this filesystem's block size */
	char	*dd_buf;	/* malloc'd buffer depending of fs bsize */
	long	dd_bbase;	/* offset to seek back to current buffer */
	long	dd_xbase;	/* offset to read next buffer */
} DIR;
/* this should only be set by opendir() and used by readdir() */
#define DDFLG_ANCIENT	1	/* only oldstyle UNIX directories supported */
#define dd_bsize	dd_blksize	/* ala sun */
#define d_fileno	d_ino		/* ala sun */

extern	DIR *opendir _PARAMS((const char *));
extern	struct dirent *readdir _PARAMS((DIR *));
extern	long telldir _PARAMS((DIR *));
extern	void seekdir _PARAMS((DIR *, long int));
extern	rewinddir _PARAMS((DIR *));
extern	void closedir _PARAMS((DIR *));
#define	rewinddir(dirp)	seekdir((dirp), (long)0)

#endif
