#ifndef _AIXPROTO_H
#define _AIXPROTO_H

#include "Xmd.h"
#include "AIXprotostr.h"

typedef struct {
    CARD8 reqType;
    BYTE mcode;
    CARD16 length B16;
    Window wid B32, parent B32;
    INT16 x B16, y B16;
    CARD16 width B16, height B16, borderWidth B16;  
    CARD16 class B16;
    VisualID visual B32;
    CARD32 mask B32;
    CARD8 depth;
    BYTE pad1,pad2,pad3;
} xGSLCreateWindowReq;

typedef struct {
    CARD8 reqType;
    BYTE mcode;
    CARD16 length B16;
    Colormap cmap B32;
    CARD8 pixel;
    BYTE pad;
    CARD16 colorlength B16;
} xChangeColorsReq;    

typedef struct {
    CARD8 reqType;
    BYTE mcode;
    CARD16 length B16;
    CARD16  modetype;
    CARD16  mode;
    } xExtChangeModeReq;

typedef struct {
    CARD8 reqType;
    BYTE mcode;
    CARD16 length B16;
    CARD32  modetype;
    } xExtQueryModeReq;

typedef struct {
    CARD8 reqType;
    BYTE mcode ;
    CARD16 length B16;
} xGenExtReq ;

typedef xGenExtReq xListInputDevicesReq ;

typedef struct {
    BYTE type;
    BOOL enabled;
    CARD16 sequenceNumber B16;
    CARD32 length B32;
    CARD16 nDevices B16;
    CARD16 pad1 B16;
    CARD32 pad3 B32;
    CARD32 pad4 B32;
    CARD32 pad5 B32;
    CARD32 pad6 B32;
    CARD32 pad7 B32;
} xListInputDevicesReply;

typedef struct {
    BYTE type; 
    BYTE pad1;
    CARD16 sequenceNumber B16;
    CARD32 length B32;  /* 0 */
    CARD32 onoff B32;
    CARD32 pad2 B32;
    CARD32 pad3 B32;
    CARD32 pad4 B32;
    CARD32 pad5 B32;
    CARD32 pad6 B32;
    } xExtQueryModeReply;

typedef xExtQueryModeReply xQueryInputDeviceReply ;

typedef struct {
    BYTE type; 
    BYTE pad1;
    CARD16 sequenceNumber B16;
    CARD32 length B32;  /* 0 */
    CARD32 kbdid B32;
    CARD32 vrmid B32;
    CARD32 displayid B32;
    CARD32 pad2 B32;
    CARD32 pad3 B32;
    CARD32 pad4 B32;
    } xGetAIXInfoReply;

#ifdef CROSSHAIR

typedef struct {
    CARD8 reqType; 
    CARD8 mcode ; 
    CARD16 length ;
    Window wid B32;
    INT16 width ;
    INT16 pixel ;
} xDefineCrossHairReq;

typedef struct {
    CARD8 reqType ; 
    CARD8 mcode ; 
    CARD16 length  ;
    Window wid B32 ;
} xUndefineCrossHairReq;

#endif

#ifdef AIXEXTSAMPLE
typedef struct {
    CARD8 reqType; 
    CARD8 mcode ; 
    CARD16 length;
    Drawable drawable;
    GContext gc;
    INT16 x,y;
} xDrawGeoTextReq;

typedef struct {
    CARD8 reqType; 
    CARD8 mcode ;      
    CARD16 length;
    GContext gc;
    INT16 xhot,yhot;
} xSetGeoTextReq;
#endif

typedef struct {
    CARD8 reqType; 
    CARD8 mcode ; 
    CARD16 length;
    Drawable drawable;
    GContext gc;
    INT16 xoff,yoff;
} xDrawPolyMarkerReq;

typedef struct {
    CARD8 reqType; 
    CARD8 mcode ; 
    CARD16 length;
    Drawable drawable;
    GContext gc;
    BYTE coordMode;
    BYTE pad1,pad2,pad3;
} xDrawPolyMarkersReq;

typedef struct {
    CARD8 reqType; 
    CARD8 mcode ;      
    CARD16 length;
    GContext gc;
    Pixmap  marker;
    INT16 xhot,yhot;
} xSetPolyMarkerReq;

typedef struct {
    CARD8 reqType;
    CARD8 mcode;
    CARD16 length B16;
    INT8 deviceid ;
    BYTE pad1,pad2,pad3 ;
} xQueryInputDeviceReq;

typedef struct {
    CARD8 reqType;
    CARD8 mcode;
    CARD16 length B16;
    INT8 deviceid ;
    INT8 mode ;	
    BYTE pad1,pad2 ;
} xSetInputDeviceReq;

typedef struct {
    CARD8 reqType;
    CARD8 mcode;
    CARD16 length B16;
    Window wid B32;
    CARD32 device B32;	
    CARD32 eventmask B32;
} xSelectDeviceInputReq;

typedef struct {
    CARD8 reqType;
    CARD8 mcode;
    CARD16 length B16;
    Window wid B32;
    CARD32 dialmask B32;
} xSelectDialReq;

typedef struct {
    CARD8 reqType;
    CARD8 mcode;
    CARD16 length B16;
    Window wid B32;
    CARD32 lpfkmask B32;
    CARD32 lightmask B32;
} xSelectLpfkReq;

typedef struct {
    CARD8 reqType;
    CARD8 mcode;
    CARD16 length B16;
    Window wid B32;
    CARD32 device B32;	
    CARD32 devicemask B32;
} xSelectDeviceReq;

#ifdef AIXSTAT

typedef struct {
    CARD8 reqType;
    BYTE  mcode;
    CARD16 length B16;
    CARD32 statmask B32;
} xResetXStatReq;

typedef struct {
    CARD8 reqType;
    BYTE  mcode;
    CARD16 length B16;
    CARD32 statmask B32;
} xSetXStatReq;

typedef struct {
    CARD8 reqType;
    BYTE  mcode;
    CARD16 length B16;
    CARD32 statcode B32;
    CARD32 statmask B32;
} xGetXStatReq;

typedef struct {
    CARD8 reqType;
    BYTE mcode;
    CARD16 length B16;
    CARD32 statmask B32;
} xStartXStatReq;

typedef xGenExtReq    	xStopXStatReq ;
typedef xGenExtReq 	xExitXStatReq ;
typedef xGenExtReq 	xContXStatReq ;

typedef struct {
    BYTE type;
    BYTE mcode;
    CARD16 sequenceNumber B16;
    CARD32 length B32; 
    CARD32 statcode ;   /* reduce this size */
    CARD32 statdata ;
    CARD32 pad3 B32;
    CARD32 pad4 B32;
    CARD32 pad5 B32;
    CARD32 pad6 B32;
    } xGetXStatReply;

#endif

#ifdef AIXGRAB

typedef struct {
    CARD8 reqType;
    CARD8 mcode;
    CARD16 length B16;
    Window grabWindow B32;
    Time time B32;
    BYTE pointerMode, lpfkMode;  
    BOOL ownerEvents;
    CARD8 key;
} xGrabLpfkKeyReq;

typedef struct {
    CARD8 reqType;
    BYTE mcode;
    CARD16 length B16;
    Time time B32;
} xUngrabLpfkReq;

typedef struct {
    CARD8 reqType;
    CARD8 mcode;
    CARD16 length B16;
    Window grabWindow B32;
    Time time B32;
    CARD16 modifiers B16;
    BYTE pointerMode, lpfkMode;  
    CARD8 key;
    BOOL ownerEvents;
    BYTE pad1,pad2;
} xGrabLpfkReq;

typedef struct {
    CARD8 reqType;
    CARD8 mcode;
    CARD16 length B16;
    Window grabWindow B32;
    Time time B32;
    CARD32 dialmask B32;
    BYTE pointerMode, dialMode;
    BOOL ownerEvents;
    BYTE pad1,pad2,pad3,pad4,pad5;
} xGrabDialReq;

typedef struct {
    CARD8 reqType;
    BYTE mcode;
    CARD16 length B16;
    Time time B32;
    CARD32 dialmask B32;
} xUngrabDialReq;

typedef struct {
    CARD8 reqType;
    BYTE mcode;
    CARD16 length B16;
    Window grabWindow B32;
    CARD8 key;
    BYTE pad1 ,pad2 , pad3 ;
} xUngrabLpfkKeyReq;

typedef struct {
    BYTE type;
    BYTE status;
    CARD16 sequenceNumber B16;
    CARD32 length B32;  /* 0 */
    CARD32 pad1 B32;
    CARD32 pad2 B32;
    CARD32 pad3 B32;
    CARD32 pad4 B32;
    CARD32 pad5 B32;
    CARD32 pad6 B32;
    } xGrabDialReply;

typedef xGrabDialReply xGrabLpfkReply;

#endif

typedef struct {
    CARD8 reqType;
    CARD8 mcode;
    CARD16 length B16;
    Window focus B32;
    Time time B32;
    CARD8 revertTo;
    BYTE pad1, pad2 ,pad3 ;
} xSetDialFocusReq;

typedef struct {
    CARD8 reqType;
    CARD8 mcode;
    CARD16 length B16;
    Window focus B32;
    Time time B32;
    CARD8 revertTo;
    BYTE pad1, pad2 ,pad3 ;
} xSetLpfkFocusReq;

typedef struct {
    CARD8 reqType;
    CARD8 mcode;
    CARD16 length B16;
    Window focus B32;
    Time time B32;
    CARD8 revertTo;
    BYTE pad1, pad2 ,pad3 ;
} xSetDeviceInputFocusReq;

typedef xGenExtReq xGetDialFocusReq ;
typedef xGenExtReq xGetLpfkFocusReq ;

typedef struct {
    CARD8 reqType;
    CARD8 mcode;
    CARD16 length B16;
    Window wid B32;
    CARD32 dialmask B32;
    CARD8 nElts;
    BYTE pad1, pad2 ,pad3 ;
} xSetDialAttributesReq;

typedef struct {
    CARD8 reqType;
    CARD8 mcode ;
    CARD16 length B16;
    Window wid B32;
    CARD32 lpfkmask B32;
    CARD32 lightmask B32;
} xSetLpfkAttributesReq;

typedef struct {
    CARD8 reqType;
    BYTE mcode ;
    CARD16 length B16;
    CARD32 dialmask B32;
    Window wid B32;
    CARD8 nElts;
    BYTE pad1, pad2 ,pad3 ;
} xGetDialAttributesReq;    

typedef struct {
    CARD8 reqType;
    BYTE mcode ;
    CARD16 length B16;
    Window wid B32;
} xGetLpfkAttributesReq;    

typedef struct {
    BYTE type;
    CARD8 nElts;
    CARD16 sequenceNumber B16;
    CARD32 length B32;
    CARD32 success B32;
    CARD32 pad3 B32;
    CARD32 pad4 B32;
    CARD32 pad5 B32;
    CARD32 pad6 B32;
    CARD32 pad7 B32;
    } xGetDialAttributesReply;

typedef struct {
    BYTE type;
    CARD8 pad;
    CARD16 sequenceNumber B16;
    CARD32 length B32;
    CARD32 success B32;
    CARD32 lpfkmask B32;
    CARD32 lightmask B32;
    CARD32 pad5 B32;
    CARD32 pad6 B32;
    CARD32 pad7 B32;
} xGetLpfkAttributesReply;    

typedef struct {
    CARD8 reqType;
    CARD8 mcode;
    CARD16 length B16;
    CARD32 dialmask B32;
    CARD8 nElts;
    BYTE pad1, pad2 ,pad3 ;
} xSetDialControlReq;

typedef struct {
    CARD8 reqType;
    CARD8 mcode ;
    CARD16 length B16;
    CARD32 lpfkmask B32;
    CARD32 lightmask B32;
} xSetLpfkControlReq;

typedef struct {
    CARD8 reqType;
    BYTE mcode ;
    CARD16 length B16;
    CARD32 dialmask B32;
    CARD8 nElts;
    BYTE pad1, pad2 ,pad3 ;
} xGetDialControlReq;    

typedef xGenExtReq xGetLpfkControlReq ;
typedef xGenExtReq xGetAIXInfoReq ;

typedef struct {
    BYTE type;
    CARD8 nElts;
    CARD16 sequenceNumber B16;
    CARD32 length B32;
    CARD32 success B32;
    CARD32 pad3 B32;
    CARD32 pad4 B32;
    CARD32 pad5 B32;
    CARD32 pad6 B32;
    CARD32 pad7 B32;
    } xGetDialControlReply;

typedef struct {
    BYTE type;
    CARD8 pad;
    CARD16 sequenceNumber B16;
    CARD32 length B32;
    CARD32 success B32;
    CARD32 lpfkmask B32;
    CARD32 lightmask B32;
    CARD32 pad5 B32;
    CARD32 pad6 B32;
    CARD32 pad7 B32;
} xGetLpfkControlReply;    

typedef struct {
    BYTE type;
    CARD8 revertTo;
    CARD16 sequenceNumber B16;
    CARD32 length B32;  /* 0 */
    Window focus B32;
    CARD32 pad1 B32;
    CARD32 pad2 B32;
    CARD32 pad3 B32;
    CARD32 pad4 B32;
    CARD32 pad5 B32;
    } xGetDeviceFocusReply;

typedef xGetDeviceFocusReply xGetDialFocusReply;
typedef xGetDeviceFocusReply xGetLpfkFocusReply;


/* 32 byte extension event */

typedef struct {
    union {
	struct {
	    BYTE type;
	    BYTE detail;
	    CARD16 sequenceNumber B16;
	    } u;
	struct {
            CARD32 pad00 B32;
	    Time time B32;
	    Window root B32, event B32, child B32;
	    INT16 rootX B16, rootY B16, eventX B16, eventY B16;
	    KeyButMask state B16;
	    BOOL sameScreen;		
	    BYTE pad1;
	} keyButtonPointer;
	struct {
	    CARD32 pad00 B32;
	    Window window B32 ;	
	    CARD32 request ;      /* what kind of mapping change */
	    CARD32 lpfkmask ;     /* lpfk input */
	    CARD32 lightmask ;    /* lpfk output */
	    CARD32 dialmask ;     /* dial */
	} AIXmappingNotify;
	struct {
            CARD32 pad00 B32;
	    Window window B32;
	    BYTE mode; 
	    BYTE devtype; 
	    BYTE pad1,pad2 ;
	} AIXfocus;
	struct {
            CARD32 pad00 B32;
            Time time B32;
	    Window root B32, event B32, child B32;
	    INT16 rootX B16, rootY B16, eventX B16, eventY B16;
	    KeyButMask state B16;
	    BOOL sameScreen;		
	    INT8 value;
	} DialLpfk;
    } u ;
} xExtEvent ;

typedef union {
    xGenericReply generic;
#ifdef AIXGRAB 
    xGrabDialReply grabDial;
    xGrabLpfkReply grabLpfk;
#endif
#ifdef AIXSTAT
    xGetXStatReply getXStat;
#endif
    xGetDialAttributesReply getWinDialAttributes;
    xGetLpfkAttributesReply getWinLpfkAttributes;
    xGetDialControlReply getDialControl;
    xGetLpfkControlReply getLpfkControl;
    xGetDialFocusReply getDialFocus;
    xGetLpfkFocusReply getLpfkFocus;
    xListInputDevicesReply listInputDevices;
    xGetAIXInfoReply getAIXInfo;
    xError error;
    xExtEvent event;
} xExtReply;

#endif /* _AIXPROTO_H */
